/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.listeners;

import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.event.HologramUnloadEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class WorldListener
implements Listener {
    private final HologramPlugin plugin;

    public WorldListener(HologramPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldLoad(WorldLoadEvent event) {
        this.plugin.loadHolograms(event.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldSave(WorldSaveEvent event) {
        this.plugin.hologramProvider().getHolograms(event.getWorld()).forEach(Hologram::persist);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        this.plugin.hologramProvider().holograms.removeIf(hologram -> {
            if (hologram.getWorld().equals((Object)event.getWorld())) {
                new HologramUnloadEvent((Hologram)hologram).callEvent();
                hologram.persist();
                return true;
            }
            return false;
        });
    }
}

