/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import net.kyori.adventure.text.Component;
import net.thenextlvl.hologram.image.ImageComponent;
import net.thenextlvl.hologram.image.SimpleImageComponent;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class SimpleAnimatedComponent
implements ImageComponent.Animated {
    private final Component[] images;
    private final Duration frameDelay;

    private SimpleAnimatedComponent(Duration frameDelay, Component ... images) {
        this.frameDelay = frameDelay;
        this.images = images;
    }

    public static SimpleAnimatedComponent read(Path file, int height) throws IOException, NoSuchElementException {
        ImageReader reader = ImageIO.getImageReadersBySuffix("GIF").next();
        ImageInputStream in = ImageIO.createImageInputStream(file.toFile());
        reader.setInput(in);
        int frameCount = reader.getNumImages(true);
        Component[] images = new Component[frameCount];
        int gifWidth = reader.getWidth(0);
        int gifHeight = reader.getHeight(0);
        BufferedImage canvas = new BufferedImage(gifWidth, gifHeight, 2);
        long totalDurationMs = 0L;
        for (int i = 0; i < frameCount; ++i) {
            BufferedImage frame = reader.read(i);
            int[] frameOffset = SimpleAnimatedComponent.getFrameOffset(reader, i);
            Graphics2D graphics = canvas.createGraphics();
            graphics.drawImage((Image)frame, frameOffset[0], frameOffset[1], null);
            graphics.dispose();
            BufferedImage snapshot = new BufferedImage(gifWidth, gifHeight, 2);
            snapshot.createGraphics().drawImage((Image)canvas, 0, 0, null);
            images[i] = SimpleImageComponent.read(snapshot, height);
            totalDurationMs += (long)SimpleAnimatedComponent.getFrameDuration(reader, i);
        }
        long avgFrameDelay = frameCount > 0 ? totalDurationMs / (long)frameCount : 100L;
        return new SimpleAnimatedComponent(Duration.ofMillis(avgFrameDelay), images);
    }

    private static int[] getFrameOffset(ImageReader reader, int frameIndex) throws IOException {
        IIOMetadata metadata = reader.getImageMetadata(frameIndex);
        Node root = metadata.getAsTree("javax_imageio_gif_image_1.0");
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!"ImageDescriptor".equals(node.getNodeName())) continue;
            NamedNodeMap attrs = node.getAttributes();
            int left = Integer.parseInt(attrs.getNamedItem("imageLeftPosition").getNodeValue());
            int top = Integer.parseInt(attrs.getNamedItem("imageTopPosition").getNodeValue());
            return new int[]{left, top};
        }
        return new int[]{0, 0};
    }

    private static int getFrameDuration(ImageReader reader, int frameIndex) throws IOException {
        IIOMetadata metadata = reader.getImageMetadata(frameIndex);
        Node root = metadata.getAsTree("javax_imageio_gif_image_1.0");
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node delayAttr;
            Node node = children.item(i);
            if (!"GraphicControlExtension".equals(node.getNodeName()) || (delayAttr = node.getAttributes().getNamedItem("delayTime")) == null) continue;
            return Integer.parseInt(delayAttr.getNodeValue()) * 10;
        }
        return 100;
    }

    @Override
    public Component[] getFrames() {
        return (Component[])this.images.clone();
    }

    @Override
    public Duration getFrameDelay() {
        return this.frameDelay;
    }

    @Override
    public Iterator<Component> iterator() {
        return new Iterator<Component>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < SimpleAnimatedComponent.this.images.length;
            }

            @Override
            public Component next() {
                return SimpleAnimatedComponent.this.images[this.i++];
            }
        };
    }
}

