/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.NoSuchElementException;
import net.kyori.adventure.text.Component;
import net.thenextlvl.hologram.image.SimpleAnimatedComponent;
import net.thenextlvl.hologram.image.SimpleImageComponent;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;

public final class ImageComponent {
    @CheckReturnValue
    @Contract(value="_, _ -> new")
    public static Component read(BufferedImage image, int height) {
        return SimpleImageComponent.read(image, height);
    }

    @CheckReturnValue
    @Contract(value="_, _ -> new")
    public static Animated readAnimated(Path file, int height) throws IOException, NoSuchElementException {
        return SimpleAnimatedComponent.read(file, height);
    }

    public static sealed interface Animated
    extends Iterable<Component>
    permits SimpleAnimatedComponent {
        @Contract(value=" -> new", pure=true)
        public Component[] getFrames();

        @Contract(value=" -> new", pure=true)
        public Duration getFrameDelay();
    }
}

