/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.economy;

import java.util.Locale;
import java.util.Optional;
import net.thenextlvl.hologram.economy.EconomyProvider;
import net.thenextlvl.service.api.economy.EconomyController;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ServiceEconomyProvider
implements EconomyProvider {
    private final Plugin plugin;

    public ServiceEconomyProvider(Plugin plugin) {
        this.plugin = plugin;
    }

    private Optional<EconomyController> getController() {
        return Optional.ofNullable((EconomyController)this.plugin.getServer().getServicesManager().load(EconomyController.class));
    }

    @Override
    public String format(Locale locale, double amount) {
        return this.getController().map(controller -> controller.format((Number)amount)).orElseGet(() -> EconomyProvider.super.format(locale, amount));
    }

    @Override
    public boolean withdraw(Player player, double amount) {
        return this.getController().flatMap(controller -> controller.getAccount((OfflinePlayer)player).map(account -> !account.getBalance().equals(account.withdraw((Number)amount)))).orElse(false);
    }
}

