/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.suggestions;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class HologramActionSuggestionProvider
implements SuggestionProvider<CommandSourceStack> {
    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        HologramLine target;
        int lineIndex;
        Hologram hologram = (Hologram)context.getLastChild().getArgument("hologram", Hologram.class);
        HologramLine line = hologram.getLine(lineIndex = (Integer)context.getLastChild().getArgument("line", Integer.TYPE) - 1).orElse(null);
        if (line == null) {
            return builder.buildFuture();
        }
        Integer pageIndex = HologramActionSuggestionProvider.tryGetArgument(context, "page");
        if (pageIndex != null && line instanceof PagedHologramLine) {
            PagedHologramLine pagedLine = (PagedHologramLine)line;
            target = pagedLine.getPage(pageIndex - 1).orElse(null);
        } else {
            target = line;
        }
        if (target == null) {
            return builder.buildFuture();
        }
        target.getActions().keySet().stream().filter(string -> string.contains(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static @Nullable Integer tryGetArgument(CommandContext<CommandSourceStack> context, String name) {
        try {
            return (Integer)context.getLastChild().getArgument(name, Integer.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

