/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.page.settings;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.util.Tick;
import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.PagedHologramLine;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramPageSettingsIntervalCommand
extends SimpleCommand {
    private HologramPageSettingsIntervalCommand(HologramPlugin plugin) {
        super(plugin, "interval", "holograms.command.page.settings.interval");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramPageSettingsIntervalCommand command = new HologramPageSettingsIntervalCommand(plugin);
        RequiredArgumentBuilder interval = Commands.argument((String)"interval", (ArgumentType)ArgumentTypes.time((int)1));
        return (LiteralArgumentBuilder)command.create().then(interval.executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean success;
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        int lineIndex = (Integer)context.getArgument("line", Integer.TYPE) - 1;
        Duration interval = Tick.of((long)((Integer)context.getArgument("interval", Integer.TYPE)).intValue());
        PagedHologramLine line = hologram.getLine(lineIndex, PagedHologramLine.class).orElse(null);
        if (line == null) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "hologram.type.paged", new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1))});
            return 0;
        }
        boolean bl = success = !line.getInterval().equals(interval);
        if (success) {
            line.setInterval(interval);
        }
        String message = success ? "hologram.page.interval.success" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1))});
        return success ? 1 : 0;
    }
}

