/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.page;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.commands.suggestions.LineSuggestionProvider;
import net.thenextlvl.hologram.commands.suggestions.PageSuggestionProvider;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.StaticHologramLine;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramPageViewPermissionCommand
extends SimpleCommand {
    private HologramPageViewPermissionCommand(HologramPlugin plugin) {
        super(plugin, "view-permission", "holograms.command.page.view-permission");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramPageViewPermissionCommand command = new HologramPageViewPermissionCommand(plugin);
        RequiredArgumentBuilder line = Commands.argument((String)"line", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)LineSuggestionProvider.PAGED_ONLY);
        RequiredArgumentBuilder page = Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)PageSuggestionProvider.INSTANCE);
        return (LiteralArgumentBuilder)command.create().then(HologramCommand.hologramArgument(plugin, true).then(line.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)page.then(Commands.literal((String)"remove").executes(command::set))).then(HologramCommand.permissionArgument(plugin).executes(command::set))).executes((Command)command))));
    }

    private int set(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer lineIndex = (Integer)context.getArgument("line", Integer.TYPE);
        Integer pageIndex = (Integer)context.getArgument("page", Integer.TYPE);
        HologramLine line = hologram.getLine(lineIndex - 1).orElse(null);
        if (line == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.line.invalid");
            return 0;
        }
        if (!(line instanceof PagedHologramLine)) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.type.paged");
            return 0;
        }
        PagedHologramLine pagedLine = (PagedHologramLine)line;
        StaticHologramLine hologramPage = pagedLine.getPage(pageIndex - 1).orElse(null);
        if (hologramPage == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.page.invalid");
            return 0;
        }
        String viewPermission = this.tryGetArgument(context, "permission", String.class).orElse(null);
        boolean success = hologramPage.setViewPermission(viewPermission);
        String message = !success ? "nothing.changed" : (viewPermission != null ? "hologram.page.view-permission.set" : "hologram.page.view-permission.removed");
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)lineIndex), Formatter.number((String)"page", (Number)pageIndex), Placeholder.unparsed((String)"permission", (String)String.valueOf(viewPermission))});
        return success ? 1 : 0;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Integer lineIndex = (Integer)context.getArgument("line", Integer.TYPE);
        Integer pageIndex = (Integer)context.getArgument("page", Integer.TYPE);
        HologramLine line = hologram.getLine(lineIndex - 1).orElse(null);
        if (line == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.line.invalid");
            return 0;
        }
        if (!(line instanceof PagedHologramLine)) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.type.paged");
            return 0;
        }
        PagedHologramLine pagedLine = (PagedHologramLine)line;
        StaticHologramLine hologramPage = pagedLine.getPage(pageIndex - 1).orElse(null);
        if (hologramPage == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.page.invalid");
            return 0;
        }
        String permission = hologramPage.getViewPermission().orElse(null);
        String message = permission != null ? "hologram.page.view-permission" : "hologram.page.view-permission.none";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)lineIndex), Formatter.number((String)"page", (Number)pageIndex), Placeholder.unparsed((String)"permission", (String)String.valueOf(permission))});
        return 1;
    }
}

