/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.page;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.commands.suggestions.LineSuggestionProvider;
import net.thenextlvl.hologram.commands.suggestions.PageSuggestionProvider;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramPageSwapCommand
extends SimpleCommand {
    private HologramPageSwapCommand(HologramPlugin plugin) {
        super(plugin, "swap", "holograms.command.page.swap");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramPageSwapCommand command = new HologramPageSwapCommand(plugin);
        RequiredArgumentBuilder line = Commands.argument((String)"line", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)LineSuggestionProvider.PAGED_ONLY);
        RequiredArgumentBuilder first = Commands.argument((String)"first", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)PageSuggestionProvider.INSTANCE);
        RequiredArgumentBuilder second = Commands.argument((String)"second", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)PageSuggestionProvider.INSTANCE);
        return (LiteralArgumentBuilder)command.create().then(HologramCommand.hologramArgument(plugin, true).then(line.then(first.then(second.executes((Command)command)))));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        int lineIndex = (Integer)context.getArgument("line", Integer.TYPE) - 1;
        Integer first = (Integer)context.getArgument("first", Integer.TYPE);
        Integer second = (Integer)context.getArgument("second", Integer.TYPE);
        HologramLine line = hologram.getLine(lineIndex).orElse(null);
        if (line == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.line.invalid");
            return 0;
        }
        if (!(line instanceof PagedHologramLine)) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.type.paged");
            return 0;
        }
        PagedHologramLine pagedLine = (PagedHologramLine)line;
        boolean success = pagedLine.swapPages(first - 1, second - 1);
        String message = success ? "hologram.page.swap" : "hologram.page.swap.failed";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1)), Formatter.number((String)"first", (Number)first), Formatter.number((String)"second", (Number)second)});
        return success ? 1 : 0;
    }
}

