/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.page;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.BrigadierCommand;
import net.thenextlvl.hologram.commands.suggestions.LineSuggestionProvider;
import net.thenextlvl.hologram.commands.suggestions.PageSuggestionProvider;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramPageRemoveCommand
extends BrigadierCommand {
    private HologramPageRemoveCommand(HologramPlugin plugin) {
        super(plugin, "remove", "holograms.command.page.remove");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramPageRemoveCommand command = new HologramPageRemoveCommand(plugin);
        RequiredArgumentBuilder line = Commands.argument((String)"line", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)LineSuggestionProvider.PAGED_ONLY);
        RequiredArgumentBuilder page = Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)PageSuggestionProvider.INSTANCE);
        return (LiteralArgumentBuilder)command.create().then(HologramCommand.hologramArgument(plugin, true).then(line.then(page.executes(command::removePage))));
    }

    private int removePage(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        int lineIndex = (Integer)context.getArgument("line", Integer.TYPE) - 1;
        int pageIndex = (Integer)context.getArgument("page", Integer.TYPE) - 1;
        HologramLine line = hologram.getLine(lineIndex).orElse(null);
        if (line == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.line.invalid");
            return 0;
        }
        if (!(line instanceof PagedHologramLine)) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.type.paged");
            return 0;
        }
        PagedHologramLine pagedLine = (PagedHologramLine)line;
        boolean removed = pagedLine.removePage(pageIndex);
        this.plugin.bundle().sendMessage((Audience)sender, removed ? "hologram.page.remove" : "hologram.line.invalid", new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1)), Formatter.number((String)"page", (Number)(pageIndex + 1))});
        return removed ? 1 : 0;
    }
}

