/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.page;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.registry.RegistryKey;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.BrigadierCommand;
import net.thenextlvl.hologram.commands.suggestions.LineSuggestionProvider;
import net.thenextlvl.hologram.commands.suggestions.tags.TagSuggestionProvider;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramPageAddCommand
extends BrigadierCommand {
    private HologramPageAddCommand(HologramPlugin plugin) {
        super(plugin, "add", "holograms.command.page.add");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramPageAddCommand command = new HologramPageAddCommand(plugin);
        RequiredArgumentBuilder line = Commands.argument((String)"line", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)LineSuggestionProvider.PAGED_ONLY);
        return (LiteralArgumentBuilder)command.create().then(HologramCommand.hologramArgument(plugin, true).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)line.then(command.addPage("block", ArgumentTypes.blockState(), (Command<CommandSourceStack>)((Command)command::addBlockPage)))).then(command.addPage("entity", ArgumentTypes.resource((RegistryKey)RegistryKey.ENTITY_TYPE), (Command<CommandSourceStack>)((Command)command::addEntityPage)))).then(command.addPage("item", ArgumentTypes.itemStack(), (Command<CommandSourceStack>)((Command)command::addItemPage)))).then(Commands.literal((String)"text").then(Commands.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).suggests(new TagSuggestionProvider(plugin)).executes(command::addTextPage)))));
    }

    private LiteralArgumentBuilder<CommandSourceStack> addPage(String name, ArgumentType<?> argumentType, Command<CommandSourceStack> command) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(Commands.argument((String)name, argumentType).executes(command));
    }

    private int addBlockPage(CommandContext<CommandSourceStack> context) {
        BlockData block = ((BlockState)context.getArgument("block", BlockState.class)).getBlockData();
        return this.addPage(context, pagedLine -> pagedLine.addBlockPage().setBlock(block));
    }

    private int addEntityPage(CommandContext<CommandSourceStack> context) {
        EntityType entity = (EntityType)context.getArgument("entity", EntityType.class);
        return this.addPage(context, pagedLine -> pagedLine.addEntityPage(entity));
    }

    private int addItemPage(CommandContext<CommandSourceStack> context) {
        ItemStack item = (ItemStack)context.getArgument("item", ItemStack.class);
        return this.addPage(context, pagedLine -> pagedLine.addItemPage().setItemStack(item));
    }

    private int addTextPage(CommandContext<CommandSourceStack> context) {
        String text = (String)context.getArgument("text", String.class);
        return this.addPage(context, pagedLine -> pagedLine.addTextPage().setUnparsedText(text));
    }

    private int addPage(CommandContext<CommandSourceStack> context, Consumer<PagedHologramLine> consumer) {
        int lineIndex;
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        HologramLine line = hologram.getLine(lineIndex = (Integer)context.getArgument("line", Integer.TYPE) - 1).orElse(null);
        if (line == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.line.invalid");
            return 0;
        }
        if (!(line instanceof PagedHologramLine)) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.type.paged");
            return 0;
        }
        PagedHologramLine pagedLine = (PagedHologramLine)line;
        consumer.accept(pagedLine);
        this.plugin.bundle().sendMessage((Audience)sender, "hologram.page.add", new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1)), Formatter.number((String)"page", (Number)pagedLine.getPageCount())});
        return 1;
    }
}

