/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.line;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.commands.suggestions.LineSuggestionProvider;
import net.thenextlvl.hologram.line.HologramLine;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramLineViewPermissionCommand
extends SimpleCommand {
    private HologramLineViewPermissionCommand(HologramPlugin plugin) {
        super(plugin, "view-permission", "holograms.command.line.view-permission");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramLineViewPermissionCommand command = new HologramLineViewPermissionCommand(plugin);
        RequiredArgumentBuilder line = Commands.argument((String)"line", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)LineSuggestionProvider.ANY_LINE);
        return (LiteralArgumentBuilder)command.create().then(HologramCommand.hologramArgument(plugin).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)line.then(Commands.literal((String)"remove").executes(command::set))).then(HologramCommand.permissionArgument(plugin).executes(command::set))).executes((Command)command)));
    }

    private int set(CommandContext<CommandSourceStack> context) {
        Integer lineIndex;
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        HologramLine hologramLine = hologram.getLine((lineIndex = (Integer)context.getArgument("line", Integer.TYPE)) - 1).orElse(null);
        if (hologramLine == null) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "hologram.line.invalid");
            return 0;
        }
        String viewPermission = this.tryGetArgument(context, "permission", String.class).orElse(null);
        boolean success = hologramLine.setViewPermission(viewPermission);
        String message = !success ? "nothing.changed" : (viewPermission != null ? "hologram.line.view-permission.set" : "hologram.line.view-permission.removed");
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)lineIndex), Placeholder.unparsed((String)"permission", (String)String.valueOf(viewPermission))});
        return success ? 1 : 0;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Integer lineIndex;
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        HologramLine hologramLine = hologram.getLine((lineIndex = (Integer)context.getArgument("line", Integer.TYPE)) - 1).orElse(null);
        if (hologramLine == null) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "hologram.line.invalid");
            return 0;
        }
        String permission = hologramLine.getViewPermission().orElse(null);
        String message = permission != null ? "hologram.line.view-permission" : "hologram.line.view-permission.none";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)lineIndex), Placeholder.unparsed((String)"permission", (String)String.valueOf(permission))});
        return 1;
    }
}

