/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.arguments.EnumArgumentType;
import net.thenextlvl.hologram.commands.edit.EditCommand;
import net.thenextlvl.hologram.commands.edit.LineTargetResolver;
import net.thenextlvl.i18n.ComponentBundle;
import org.bukkit.entity.ItemDisplay;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class EditTransformationCommand
extends EditCommand {
    private EditTransformationCommand(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        super(plugin, "transformation", resolver);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        EditTransformationCommand command = new EditTransformationCommand(plugin, resolver);
        RequiredArgumentBuilder named = Commands.argument((String)"transformation", new EnumArgumentType<ItemDisplay.ItemDisplayTransform>(ItemDisplay.ItemDisplayTransform.class));
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(named.executes((Command)command))).executes((Command)command);
    }

    @Override
    public int run(CommandContext<CommandSourceStack> context, LineTargetResolver resolver) throws CommandSyntaxException {
        return resolver.resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            Optional<ItemDisplay.ItemDisplayTransform> transformation = this.tryGetArgument(context, "transformation", ItemDisplay.ItemDisplayTransform.class);
            ComponentBundle componentBundle = this.plugin.bundle();
            Component transformationName = componentBundle.component(switch (transformation.orElseGet(line::getItemDisplayTransform)) {
                default -> throw new MatchException(null, null);
                case ItemDisplay.ItemDisplayTransform.FIRSTPERSON_LEFTHAND -> "transformation.firstperson-lefthand";
                case ItemDisplay.ItemDisplayTransform.FIRSTPERSON_RIGHTHAND -> "transformation.firstperson-righthand";
                case ItemDisplay.ItemDisplayTransform.FIXED -> "transformation.fixed";
                case ItemDisplay.ItemDisplayTransform.GROUND -> "transformation.ground";
                case ItemDisplay.ItemDisplayTransform.GUI -> "transformation.gui";
                case ItemDisplay.ItemDisplayTransform.HEAD -> "transformation.head";
                case ItemDisplay.ItemDisplayTransform.NONE -> "transformation.none";
                case ItemDisplay.ItemDisplayTransform.THIRDPERSON_LEFTHAND -> "transformation.thirdperson-lefthand";
                case ItemDisplay.ItemDisplayTransform.THIRDPERSON_RIGHTHAND -> "transformation.thirdperson-righthand";
            }, (Audience)((CommandSourceStack)context.getSource()).getSender());
            String message = transformation.map(value -> this.set(value, line::setItemDisplayTransform, "hologram.transformation")).orElse("hologram.transformation.query");
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{TagResolver.resolver((TagResolver[])placeholders), Placeholder.component((String)"transformation", (ComponentLike)transformationName)});
            return 1;
        }, LineTargetResolver.LineType.ITEM);
    }
}

