/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.edit.EditCommand;
import net.thenextlvl.hologram.commands.edit.LineTargetResolver;
import net.thenextlvl.hologram.line.DisplayHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class EditScaleCommand
extends EditCommand {
    private EditScaleCommand(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        super(plugin, "scale", resolver);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        EditScaleCommand command = new EditScaleCommand(plugin, resolver);
        RequiredArgumentBuilder x = Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)100.0f));
        RequiredArgumentBuilder y = Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)100.0f));
        RequiredArgumentBuilder z = Commands.argument((String)"z", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)100.0f));
        RequiredArgumentBuilder scale = Commands.argument((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)100.0f));
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(scale.executes((Command)command))).then(x.then(y.then(z.executes((Command)command))))).executes((Command)command);
    }

    @Override
    public int run(CommandContext<CommandSourceStack> context, LineTargetResolver resolver) throws CommandSyntaxException {
        return resolver.resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            Vector3f ored;
            Optional<Vector3f> scale = this.tryGetArgument(context, "scale", Float.TYPE).map(Vector3f::new).or(() -> this.tryGetArgument(context, "x", Float.TYPE).map(x -> {
                Float y = (Float)context.getArgument("y", Float.TYPE);
                Float z = (Float)context.getArgument("z", Float.TYPE);
                return new Vector3f(x.floatValue(), y.floatValue(), z.floatValue());
            }));
            String message = scale.map(vector3f -> {
                if (line instanceof DisplayHologramLine) {
                    DisplayHologramLine displayLine = (DisplayHologramLine)line;
                    Transformation transformation = displayLine.getTransformation();
                    return this.set(vector3f, v -> {
                        transformation.getScale().set((Vector3fc)v);
                        return displayLine.setTransformation(transformation);
                    }, "hologram.scale");
                }
                if (line instanceof EntityHologramLine) {
                    EntityHologramLine entityLine = (EntityHologramLine)line;
                    return this.set(Float.valueOf(vector3f.y()), value -> entityLine.setScale(value.floatValue()), "hologram.scale");
                }
                throw new IllegalArgumentException("Invalid line type");
            }).orElse("hologram.scale.query");
            if (line instanceof DisplayHologramLine) {
                DisplayHologramLine displayLine = (DisplayHologramLine)line;
                ored = displayLine.getTransformation().getScale();
            } else if (line instanceof EntityHologramLine) {
                EntityHologramLine entityLine = (EntityHologramLine)line;
                ored = new Vector3f((float)entityLine.getScale());
            } else {
                throw new IllegalArgumentException("Invalid line type");
            }
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, TagResolver.resolver((TagResolver[])placeholders), Formatter.number((String)"x", (Number)Float.valueOf(ored.x())), Formatter.number((String)"y", (Number)Float.valueOf(ored.y())), Formatter.number((String)"z", (Number)Float.valueOf(ored.z())));
            return 1;
        }, LineTargetResolver.LineType.STATIC);
    }
}

