/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.locale.LanguageTags;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class LocaleArgumentType
implements CustomArgumentType.Converted<Locale, String> {
    private final HologramPlugin plugin;
    private final boolean filter;

    public LocaleArgumentType(HologramPlugin plugin, boolean filter) {
        this.plugin = plugin;
        this.filter = filter;
    }

    public Locale convert(String nativeType) {
        Locale locale = LanguageTags.getLocale(nativeType);
        if (locale != null) {
            return locale;
        }
        throw new NullPointerException("Unknown language: " + nativeType);
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String key = (String)context.getLastChild().getArgument("translation key", String.class);
        LanguageTags.getLanguages().filter(entry -> !this.filter || this.plugin.translations().contains(key, (Locale)entry.getKey())).map(entry -> StringArgumentType.escapeIfRequired((String)((String)entry.getValue()))).filter(name -> name.toLowerCase().contains(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

