/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramLike;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.line.LineType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramArgumentType
implements CustomArgumentType.Converted<Hologram, String> {
    private final HologramPlugin plugin;
    private final boolean pagedOnly;

    public HologramArgumentType(HologramPlugin plugin, boolean pagedOnly) {
        this.plugin = plugin;
        this.pagedOnly = pagedOnly;
    }

    public Hologram convert(String nativeType) {
        return this.plugin.hologramProvider().getHologram(nativeType).orElseThrow(() -> new NullPointerException("No hologram was found"));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        this.plugin.hologramProvider().getHolograms().filter(name -> !this.pagedOnly || name.getLines().anyMatch(line -> line.getType() == LineType.PAGED)).map(HologramLike::getName).map(StringArgumentType::escapeIfRequired).filter(name -> name.toLowerCase().contains(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }
}

