/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.action.argument;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.RotationResolver;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.Rotation;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.action.ActionTypes;
import net.thenextlvl.hologram.commands.action.ActionTargetResolver;
import net.thenextlvl.hologram.commands.action.argument.HologramActionCommand;
import net.thenextlvl.hologram.models.LazyLocation;
import org.bukkit.Location;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class TeleportCommand
extends HologramActionCommand<Location> {
    private TeleportCommand(HologramPlugin plugin, ActionTargetResolver.Builder resolver) {
        super(plugin, ActionTypes.types().teleport(), "teleport", resolver);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin, ActionTargetResolver.Builder resolver) {
        TeleportCommand command = new TeleportCommand(plugin, resolver);
        RequiredArgumentBuilder position = (RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)ArgumentTypes.finePosition()).executes((Command)command);
        RequiredArgumentBuilder rotation = (RequiredArgumentBuilder)Commands.argument((String)"rotation", (ArgumentType)ArgumentTypes.rotation()).executes((Command)command);
        RequiredArgumentBuilder world = (RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).executes((Command)command);
        return (LiteralArgumentBuilder)command.create().then(position.then(rotation.then((ArgumentBuilder)world)));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.resolverBuilder.build(context, this.plugin).resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            FinePosition position = (FinePosition)((FinePositionResolver)context.getArgument("position", FinePositionResolver.class)).resolve((CommandSourceStack)context.getSource());
            RotationResolver rotationResolver = this.tryGetArgument(context, "rotation", RotationResolver.class).orElse(null);
            World world = this.tryGetArgument(context, "world", World.class).orElseGet(() -> ((CommandSourceStack)context.getSource()).getLocation().getWorld());
            Rotation rotation = rotationResolver != null ? (Rotation)rotationResolver.resolve((CommandSourceStack)context.getSource()) : Rotation.rotation((float)0.0f, (float)0.0f);
            Location location = position.toLocation(world).setRotation(rotation);
            return this.addAction(context, hologram, line, new LazyLocation(location));
        });
    }
}

