/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.action.argument;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.time.Duration;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.action.ActionType;
import net.thenextlvl.hologram.action.ClickAction;
import net.thenextlvl.hologram.commands.action.ActionTargetResolver;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.models.ClickTypes;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
abstract class HologramActionCommand<T>
extends SimpleCommand {
    private final ActionType<T> actionType;
    protected final ActionTargetResolver.Builder resolverBuilder;

    protected HologramActionCommand(HologramPlugin plugin, ActionType<T> actionType, String name, ActionTargetResolver.Builder resolver) {
        super(plugin, name, null);
        this.actionType = actionType;
        this.resolverBuilder = resolver;
    }

    protected int addAction(CommandContext<CommandSourceStack> context, Hologram hologram, HologramLine line, T input) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String actionName = (String)context.getArgument("action", String.class);
        ClickTypes clickTypes = (ClickTypes)((Object)context.getArgument("click-types", ClickTypes.class));
        Optional<ClickAction<?>> previous = line.getAction(actionName);
        Duration cooldown = previous.map(ClickAction::getCooldown).orElse(Duration.ZERO);
        String permission = previous.flatMap(ClickAction::getPermission).orElse(null);
        Integer chance = previous.map(ClickAction::getChance).orElse(100);
        Double cost = previous.map(ClickAction::getCost).orElse(0.0);
        boolean success = line.addAction(actionName, this.plugin.clickActionFactory().create(this.actionType, clickTypes.getClickTypes(), input, action -> {
            action.setChance(chance);
            action.setCooldown(cooldown);
            action.setCost(cost);
            action.setPermission(permission);
        }));
        String message = success ? "hologram.action.added" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"action", (String)actionName), Placeholder.unparsed((String)"hologram", (String)hologram.getName())});
        return success ? 1 : 0;
    }
}

