/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.action;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.StaticHologramLine;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public sealed interface ActionTargetResolver {
    public static final Builder LINE = Line::new;
    public static final Builder PAGE = Page::new;

    public CommandContext<CommandSourceStack> context();

    public HologramPlugin plugin();

    public int resolve(Resolved var1) throws CommandSyntaxException;

    @FunctionalInterface
    public static interface Builder {
        public ActionTargetResolver build(CommandContext<CommandSourceStack> var1, HologramPlugin var2);
    }

    @FunctionalInterface
    public static interface Resolved {
        public int resolved(Hologram var1, HologramLine var2, int var3, @Nullable Integer var4, TagResolver ... var5) throws CommandSyntaxException;
    }

    public record Page(CommandContext<CommandSourceStack> context, HologramPlugin plugin) implements ActionTargetResolver
    {
        @Override
        public int resolve(Resolved handler) throws CommandSyntaxException {
            Hologram hologram = (Hologram)this.context.getArgument("hologram", Hologram.class);
            int lineIndex = (Integer)this.context.getArgument("line", Integer.TYPE) - 1;
            int pageIndex = (Integer)this.context.getArgument("page", Integer.TYPE) - 1;
            CommandSender sender = ((CommandSourceStack)this.context.getSource()).getSender();
            HologramLine line = hologram.getLine(lineIndex).orElse(null);
            if (line == null) {
                this.plugin.bundle().sendMessage((Audience)sender, "hologram.line.invalid");
                return 0;
            }
            if (!(line instanceof PagedHologramLine)) {
                this.plugin.bundle().sendMessage((Audience)sender, "hologram.type.paged");
                return 0;
            }
            PagedHologramLine pagedLine = (PagedHologramLine)line;
            StaticHologramLine page = pagedLine.getPage(pageIndex).orElse(null);
            if (page == null) {
                this.plugin.bundle().sendMessage((Audience)sender, "hologram.line.invalid");
                return 0;
            }
            return handler.resolved(hologram, page, lineIndex, pageIndex, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1)), Formatter.number((String)"page", (Number)(pageIndex + 1))});
        }
    }

    public record Line(CommandContext<CommandSourceStack> context, HologramPlugin plugin) implements ActionTargetResolver
    {
        @Override
        public int resolve(Resolved handler) throws CommandSyntaxException {
            int lineIndex;
            Hologram hologram = (Hologram)this.context.getArgument("hologram", Hologram.class);
            HologramLine line = hologram.getLine(lineIndex = (Integer)this.context.getArgument("line", Integer.TYPE) - 1).orElse(null);
            if (line == null) {
                this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)this.context.getSource()).getSender(), "hologram.line.invalid");
                return 0;
            }
            return handler.resolved(hologram, line, lineIndex, null, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1))});
        }
    }
}

