/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.action;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.action.ClickAction;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.action.ActionCommand;
import net.thenextlvl.hologram.commands.action.ActionTargetResolver;
import net.thenextlvl.hologram.commands.action.HologramActionCommand;
import net.thenextlvl.hologram.line.HologramLine;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class ActionPermissionCommand
extends ActionCommand {
    private ActionPermissionCommand(HologramPlugin plugin, ActionTargetResolver.Builder resolver) {
        super(plugin, "permission", "holograms.command.action.permission", resolver);
    }

    static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin, HologramActionCommand.ArgumentChainFactory chainFactory, ActionTargetResolver.Builder resolver) {
        ActionPermissionCommand command = new ActionPermissionCommand(plugin, resolver);
        HologramActionCommand.ArgumentChain chain = chainFactory.create();
        chain.tail().then(ActionPermissionCommand.actionArgument(plugin).then(Commands.literal((String)"remove").executes(command::set)).then(HologramCommand.permissionArgument(plugin).executes(command::set)).executes((Command)command));
        return (LiteralArgumentBuilder)command.create().then(chain.build());
    }

    private int set(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.resolverBuilder.build(context, this.plugin).resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            String actionName = (String)context.getArgument("action", String.class);
            ClickAction action = line.getAction(actionName).orElse(null);
            String permission = this.tryGetArgument(context, "permission", String.class).orElse(null);
            if (action == null) {
                this.plugin.bundle().sendMessage((Audience)sender, "hologram.action.not_found", new TagResolver[]{Placeholder.parsed((String)"hologram", (String)hologram.getName()), Placeholder.unparsed((String)"action", (String)actionName)});
                return 0;
            }
            boolean success = action.setPermission(permission);
            String message = success ? (permission != null ? "hologram.action.permission.set" : "hologram.action.permission.removed") : "nothing.changed";
            this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"action", (String)actionName), Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Placeholder.unparsed((String)"permission", (String)String.valueOf(permission))});
            return success ? 1 : 0;
        });
    }

    @Override
    public int run(CommandContext<CommandSourceStack> context, Hologram hologram, HologramLine line, ClickAction<?> action, String actionName, TagResolver ... placeholders) {
        String message = action.getPermission().isPresent() ? "hologram.action.permission" : "hologram.action.permission.none";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{TagResolver.resolver((TagResolver[])placeholders), Placeholder.unparsed((String)"permission", (String)action.getPermission().orElse("null")), Placeholder.unparsed((String)"action", (String)actionName)});
        return 1;
    }
}

