/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.RotationResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import io.papermc.paper.math.Rotation;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramTeleportCommand
extends SimpleCommand {
    private HologramTeleportCommand(HologramPlugin plugin) {
        super(plugin, "teleport", "holograms.command.teleport");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramTeleportCommand command = new HologramTeleportCommand(plugin);
        RequiredArgumentBuilder rotation = (RequiredArgumentBuilder)Commands.argument((String)"rotation", (ArgumentType)ArgumentTypes.rotation()).executes((Command)command);
        RequiredArgumentBuilder world = (RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).executes((Command)command);
        RequiredArgumentBuilder position = (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)ArgumentTypes.finePosition()).then(rotation.then((ArgumentBuilder)world))).executes((Command)command);
        RequiredArgumentBuilder entity = (RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)ArgumentTypes.entity()).executes((Command)command);
        return (LiteralArgumentBuilder)command.create().then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)HologramCommand.hologramArgument(plugin).then((ArgumentBuilder)position)).then((ArgumentBuilder)entity)).executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Location position;
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        Rotation rotation = this.resolveArgument(context, "rotation", RotationResolver.class).orElseGet(() -> ((Location)hologram.getLocation()).getRotation());
        Location target = this.resolveArgument(context, "target", EntitySelectorArgumentResolver.class).map(entity -> ((Entity)entity.getFirst()).getLocation()).orElse(null);
        Location location = position = target == null ? (Location)this.resolveArgument(context, "position", FinePositionResolver.class).map(resolved -> resolved.toLocation(this.tryGetArgument(context, "world", World.class).orElseGet(() -> ((Location)((CommandSourceStack)context.getSource()).getLocation()).getWorld()))).orElse(null) : target;
        if (position == null && sender instanceof Player) {
            Player player = (Player)sender;
            player.teleportAsync(hologram.getLocation(), PlayerTeleportEvent.TeleportCause.COMMAND).thenAccept(success -> {
                String message = success != false ? "hologram.teleport.success" : "hologram.teleport.failed";
                this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName())});
            });
            return 1;
        }
        if (position != null) {
            hologram.teleportAsync(position.setRotation(rotation)).thenAccept(success -> {
                String message = success != false ? "hologram.move.success" : "hologram.move.failed";
                this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName())});
            });
            return 1;
        }
        this.plugin.bundle().sendMessage((Audience)sender, "command.sender");
        return 0;
    }
}

