/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.action;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.thenextlvl.hologram.action.ActionType;
import net.thenextlvl.hologram.action.ActionTypeRegistry;
import net.thenextlvl.hologram.action.ActionTypes;
import org.jetbrains.annotations.Unmodifiable;

final class SimpleActionTypeRegistry
implements ActionTypeRegistry {
    public static final ActionTypeRegistry INSTANCE = new SimpleActionTypeRegistry();
    private final Set<ActionType<?>> actionTypes = new CopyOnWriteArraySet<ActionType>(Set.of(ActionTypes.types().connect(), ActionTypes.types().cyclePage(), ActionTypes.types().playSound(), ActionTypes.types().runCommand(), ActionTypes.types().runConsoleCommand(), ActionTypes.types().sendActionbar(), ActionTypes.types().sendMessage(), ActionTypes.types().sendTitle(), ActionTypes.types().setPage(), ActionTypes.types().teleport(), ActionTypes.types().transfer()));

    SimpleActionTypeRegistry() {
    }

    @Override
    public boolean register(ActionType<?> type) {
        return !this.isRegistered(type.name()) && this.actionTypes.add(type);
    }

    @Override
    public boolean isRegistered(ActionType<?> type) {
        return this.actionTypes.contains(type);
    }

    @Override
    public boolean isRegistered(String name) {
        return this.actionTypes.stream().anyMatch(actionType -> actionType.name().equals(name));
    }

    @Override
    public boolean unregister(ActionType<?> type) {
        return this.actionTypes.remove(type);
    }

    @Override
    public <T> Optional<ActionType<T>> getByName(String name) {
        return this.actionTypes.stream().filter(actionType -> actionType.name().equals(name)).map(actionType -> actionType).findAny();
    }

    @Override
    public @Unmodifiable Set<ActionType<?>> getActionTypes() {
        return Set.copyOf(this.actionTypes);
    }
}

