/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.suggestions.tags;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.suggestions.tags.ImageTagSuggestionProvider;
import net.thenextlvl.hologram.commands.suggestions.tags.LangTagSuggestionProvider;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class TagSuggestionProvider<S>
implements SuggestionProvider<S> {
    private final HologramPlugin plugin;
    private final Map<String, @Nullable SuggestionProvider<S>> tags;

    public TagSuggestionProvider(HologramPlugin plugin) {
        this.plugin = plugin;
        this.tags = new HashMap<String, SuggestionProvider<S>>();
        this.tags.put("<lang:", new LangTagSuggestionProvider(plugin));
        this.tags.put("<image:", new ImageTagSuggestionProvider());
        this.tags.put("<player>", null);
        this.tags.put("<players>", null);
        this.tags.put("<hologram>", null);
        this.tags.put("<lines>", null);
        this.tags.put("<page>", null);
        this.tags.put("<pages>", null);
    }

    public TagSuggestionProvider(HologramPlugin plugin, Map<String, @Nullable SuggestionProvider<S>> tags) {
        this.plugin = plugin;
        this.tags = tags;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<S> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String remaining = builder.getRemaining();
        int start = builder.getStart() + remaining.length();
        for (Map.Entry<String, SuggestionProvider<S>> entry : this.tags.entrySet()) {
            int index;
            String tag = entry.getKey();
            SuggestionProvider<S> provider = entry.getValue();
            if (provider == null || (index = remaining.lastIndexOf(tag)) == -1 || remaining.indexOf(62, index) != -1) continue;
            SuggestionsBuilder offset = builder.createOffset(builder.getStart() + index + tag.length());
            return provider.getSuggestions(context, offset);
        }
        int lastOpen = remaining.lastIndexOf(60);
        boolean unclosed = lastOpen != -1 && remaining.indexOf(62, lastOpen) == -1;
        String partial = unclosed ? remaining.substring(lastOpen) : null;
        SuggestionsBuilder offset = builder.createOffset(unclosed ? builder.getStart() + lastOpen : start);
        for (Map.Entry<String, SuggestionProvider<S>> entry : this.tags.entrySet()) {
            if (partial != null && !entry.getKey().startsWith(partial)) continue;
            offset.suggest(entry.getKey());
        }
        builder.add(offset);
        return builder.buildFuture();
    }
}

