/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.arguments.ColorArgumentType;
import net.thenextlvl.hologram.commands.edit.EditCommand;
import net.thenextlvl.hologram.commands.edit.LineTargetResolver;
import org.bukkit.Color;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class EditBackgroundColorCommand
extends EditCommand {
    private EditBackgroundColorCommand(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        super(plugin, "background-color", resolver);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        EditBackgroundColorCommand command = new EditBackgroundColorCommand(plugin, resolver);
        RequiredArgumentBuilder named = Commands.argument((String)"color", (ArgumentType)ArgumentTypes.namedColor());
        RequiredArgumentBuilder hex = Commands.argument((String)"hex", (ArgumentType)new ColorArgumentType());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(named.executes((Command)command))).then(hex.executes((Command)command))).then(Commands.literal((String)"reset").executes(command::reset))).executes((Command)command);
    }

    private int reset(CommandContext<CommandSourceStack> context) {
        LineTargetResolver resolver = this.resolver.build(context, this.plugin);
        return resolver.resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            String message = this.set(null, line::setBackgroundColor, "hologram.text.background-color.reset");
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, placeholders);
            return 1;
        }, LineTargetResolver.LineType.TEXT);
    }

    @Override
    public int run(CommandContext<CommandSourceStack> context, LineTargetResolver resolver) throws CommandSyntaxException {
        return resolver.resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            Optional<Color> color = this.tryGetArgument(context, "hex", Color.class).or(() -> this.tryGetArgument(context, "color", NamedTextColor.class).map(TextColor::value).map(Color::fromRGB));
            String message = color.map(c -> this.set(c, line::setBackgroundColor, "hologram.text.background-color")).orElseGet(() -> line.getBackgroundColor().isPresent() ? "hologram.background-color.query" : "hologram.background-color.query.none");
            String currentColor = color.or(line::getBackgroundColor).map(Color::asARGB).map(Integer::toHexString).map("#"::concat).orElse("none");
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{TagResolver.resolver((TagResolver[])placeholders), Placeholder.unparsed((String)"color", (String)currentColor)});
            return 1;
        }, LineTargetResolver.LineType.TEXT);
    }
}

