/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.action;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.action.ClickAction;
import net.thenextlvl.hologram.commands.action.ActionTargetResolver;
import net.thenextlvl.hologram.commands.action.HologramActionCommand;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class ActionListCommand
extends SimpleCommand {
    private final ActionTargetResolver.Builder resolverBuilder;

    private ActionListCommand(HologramPlugin plugin, ActionTargetResolver.Builder resolver) {
        super(plugin, "list", "holograms.command.action.list");
        this.resolverBuilder = resolver;
    }

    static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin, HologramActionCommand.ArgumentChainFactory chainFactory, ActionTargetResolver.Builder resolver) {
        ActionListCommand command = new ActionListCommand(plugin, resolver);
        HologramActionCommand.ArgumentChain chain = chainFactory.create();
        ArgumentBuilder<CommandSourceStack, ?> head = resolver == ActionTargetResolver.PAGE ? chain.line() : chain.hologram();
        head.executes(command::listAll);
        chain.tail().executes((Command)command);
        return (LiteralArgumentBuilder)command.create().then(chain.build());
    }

    private int listAll(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        if (this.resolverBuilder == ActionTargetResolver.LINE) {
            return this.listAllLines(context, hologram);
        }
        Integer lineNumber = (Integer)context.getArgument("line", Integer.TYPE);
        HologramLine line = hologram.getLine(lineNumber - 1).orElse(null);
        if (line == null) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.line.invalid");
            return 0;
        }
        if (!(line instanceof PagedHologramLine)) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.type.paged");
            return 0;
        }
        PagedHologramLine pagedLine = (PagedHologramLine)line;
        return this.listAllPages(context, hologram, pagedLine, lineNumber);
    }

    private int listAllLines(CommandContext<CommandSourceStack> context, Hologram hologram) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        AtomicInteger count = new AtomicInteger();
        hologram.forEach(line -> {
            if (!line.hasActions()) {
                return;
            }
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.action.list.header", new TagResolver[]{Placeholder.parsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(hologram.getLineIndex((HologramLine)line) + 1))});
            line.forEachAction((name, action) -> {
                this.plugin.bundle().sendMessage((Audience)sender, "hologram.action.list", new TagResolver[]{Placeholder.parsed((String)"action", (String)name), this.actionResolvers((Audience)sender, (ClickAction<?>)action)});
                count.incrementAndGet();
            });
        });
        if (count.get() == 0) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.action.list.empty", new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName())});
            return 0;
        }
        return 1;
    }

    private int listAllPages(CommandContext<CommandSourceStack> context, Hologram hologram, PagedHologramLine pagedLine, int lineNumber) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        AtomicInteger count = new AtomicInteger();
        pagedLine.forEachPage(line -> {
            if (line.getActions().isEmpty()) {
                return;
            }
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.action.list.header.page", new TagResolver[]{Placeholder.parsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)lineNumber), Formatter.number((String)"page", (Number)(pagedLine.getPageIndex((HologramLine)line) + 1))});
            line.forEachAction((name, action) -> {
                this.plugin.bundle().sendMessage((Audience)sender, "hologram.action.list", new TagResolver[]{Placeholder.parsed((String)"action", (String)name), this.actionResolvers((Audience)sender, (ClickAction<?>)action)});
                count.incrementAndGet();
            });
        });
        if (count.get() == 0) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.action.list.empty", new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName())});
            return 0;
        }
        return 1;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.resolverBuilder.build(context, this.plugin).resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            if (!line.hasActions()) {
                this.plugin.bundle().sendMessage((Audience)sender, "hologram.action.list.empty", new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName())});
                return 0;
            }
            String header = pageIndex != null ? "hologram.action.list.header.page" : "hologram.action.list.header";
            this.plugin.bundle().sendMessage((Audience)sender, header, placeholders);
            line.forEachAction((name, action) -> this.plugin.bundle().sendMessage((Audience)sender, "hologram.action.list", new TagResolver[]{TagResolver.resolver((TagResolver[])placeholders), Placeholder.parsed((String)"action", (String)name), this.actionResolvers((Audience)sender, (ClickAction<?>)action)}));
            return 1;
        });
    }

    private TagResolver actionResolvers(Audience audience, ClickAction<?> action) {
        return TagResolver.resolver((TagResolver[])new TagResolver[]{Formatter.number((String)"chance", (Number)action.getChance()), Formatter.number((String)"cooldown", (Number)((double)action.getCooldown().toMillis() / 1000.0)), Placeholder.parsed((String)"action_type", (String)action.getActionType().name()), Placeholder.parsed((String)"cost", (String)this.plugin.economyProvider.format(audience, action.getCost())), Placeholder.parsed((String)"permission", (String)action.getPermission().orElse("null"))});
    }
}

