/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.suggestions.tags;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ImageTagSuggestionProvider<S>
implements SuggestionProvider<S> {
    public CompletableFuture<Suggestions> getSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining();
        String stripped = remaining.strip();
        if ("https://".startsWith(stripped)) {
            builder.suggest("https://");
        } else if (stripped.endsWith(",")) {
            SuggestionsBuilder offset = builder.createOffset(builder.getStart() + remaining.lastIndexOf(44) + 1);
            for (int i = 1; i <= 9; ++i) {
                offset.suggest(i);
            }
            builder.add(offset);
        } else if (stripped.contains(",") && Character.isDigit(stripped.charAt(stripped.length() - 1))) {
            int beginIndex = remaining.lastIndexOf(44) + 1;
            SuggestionsBuilder offset = builder.createOffset(builder.getStart() + beginIndex);
            String number = remaining.substring(beginIndex).replace(" ", "");
            for (int i = 0; i <= 9; ++i) {
                offset.suggest(number + i);
            }
            builder.add(offset);
            SuggestionsBuilder end = builder.createOffset(builder.getStart() + beginIndex);
            builder.add(end.suggest(number + ">"));
        } else if (!stripped.endsWith("//")) {
            SuggestionsBuilder offset = builder.createOffset(builder.getStart() + stripped.length());
            if (!stripped.contains(",")) {
                builder.add(offset.suggest(","));
            }
            builder.add(offset.suggest(">"));
        }
        return builder.buildFuture();
    }
}

