/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.suggestions;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.translation.Translatable;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.bukkit.Material;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class LineSuggestionProvider
implements SuggestionProvider<CommandSourceStack> {
    public static final LineSuggestionProvider ANY_LINE = new LineSuggestionProvider(false, "hologram");
    public static final LineSuggestionProvider PAGED_ONLY = new LineSuggestionProvider(true, "hologram");
    private final boolean pagedOnly;
    private final String argument;

    public LineSuggestionProvider(boolean pagedOnly, String argument) {
        this.pagedOnly = pagedOnly;
        this.argument = argument;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Hologram hologram = (Hologram)context.getLastChild().getArgument(this.argument, Hologram.class);
        for (int index = 1; index <= hologram.getLineCount(); ++index) {
            HologramLine hologramLine;
            String line = String.valueOf(index);
            if (!line.contains(builder.getRemaining()) || (hologramLine = (HologramLine)hologram.getLine(index - 1).orElse(null)) == null || this.pagedOnly && hologramLine.getType() != LineType.PAGED) continue;
            builder.suggest(line, LineSuggestionProvider.getTooltip(hologramLine));
        }
        return builder.buildFuture();
    }

    static Message getTooltip(HologramLine line) {
        HologramLine hologramLine = line;
        Objects.requireNonNull(hologramLine);
        HologramLine hologramLine2 = hologramLine;
        int n = 0;
        TextComponent tooltip = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockHologramLine.class, EntityHologramLine.class, ItemHologramLine.class, TextHologramLine.class, PagedHologramLine.class}, (Object)hologramLine2, n)) {
            case 0 -> {
                BlockHologramLine blockLine = (BlockHologramLine)hologramLine2;
                yield (TextComponent)Component.text((String)"Block: ").append((Component)Component.translatable((Translatable)blockLine.getBlock().getMaterial()));
            }
            case 1 -> {
                EntityHologramLine entityLine = (EntityHologramLine)hologramLine2;
                yield (TextComponent)Component.text((String)"Entity: ").append((Component)Component.translatable((Translatable)entityLine.getEntityType()));
            }
            case 2 -> {
                ItemHologramLine itemLine = (ItemHologramLine)hologramLine2;
                yield (TextComponent)Component.text((String)"Item: ").append((Component)Component.translatable((Translatable)(itemLine.isPlayerHead() ? Material.PLAYER_HEAD : itemLine.getItemStack().getType())));
            }
            case 3 -> {
                TextHologramLine textLine = (TextHologramLine)hologramLine2;
                yield textLine.getUnparsedText().map(component -> MiniMessage.miniMessage().deserialize((Object)("Text: " + component.replace("\n", "\\n")))).orElse((Component)Component.empty());
            }
            case 4 -> {
                PagedHologramLine pagedLine = (PagedHologramLine)hologramLine2;
                yield (TextComponent)Component.text((String)"Paged: ").append((Component)Component.text((int)pagedLine.getPageCount()));
            }
            default -> Component.text((String)("Unknown Line " + line.getClass().getName()));
        };
        return (Message)MessageComponentSerializer.message().serialize((Component)tooltip);
    }
}

