/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.edit.EditCommand;
import net.thenextlvl.hologram.commands.edit.EditLeftRotationCommand;
import net.thenextlvl.hologram.commands.edit.EditRightRotationCommand;
import net.thenextlvl.hologram.commands.edit.LineTargetResolver;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.jspecify.annotations.NullMarked;

@NullMarked
abstract sealed class EditRotationCommand
extends EditCommand
permits EditLeftRotationCommand, EditRightRotationCommand {
    private final Function<Transformation, Quaternionf> rotationGetter;
    private final String queryKey;
    private final String successKey;

    protected EditRotationCommand(HologramPlugin plugin, String name, LineTargetResolver.Builder resolver, Function<Transformation, Quaternionf> rotationGetter, String queryKey, String successKey) {
        super(plugin, name, resolver);
        this.queryKey = queryKey;
        this.successKey = successKey;
        this.rotationGetter = rotationGetter;
    }

    protected static LiteralArgumentBuilder<CommandSourceStack> create(EditRotationCommand command) {
        RequiredArgumentBuilder x = Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg());
        RequiredArgumentBuilder y = Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg());
        RequiredArgumentBuilder z = Commands.argument((String)"z", (ArgumentType)FloatArgumentType.floatArg());
        RequiredArgumentBuilder w = Commands.argument((String)"w", (ArgumentType)FloatArgumentType.floatArg());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(x.then(y.then(((RequiredArgumentBuilder)z.then(w.executes((Command)command))).executes((Command)command))))).executes((Command)command);
    }

    @Override
    public int run(CommandContext<CommandSourceStack> context, LineTargetResolver resolver) throws CommandSyntaxException {
        return resolver.resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            Optional<Quaternionf> rotation = this.tryGetArgument(context, "x", Float.TYPE).map(x -> {
                Float y = (Float)context.getArgument("y", Float.TYPE);
                Float z = (Float)context.getArgument("z", Float.TYPE);
                Float w = this.tryGetArgument(context, "w", Float.TYPE).orElse(Float.valueOf(1.0f));
                return new Quaternionf(x.floatValue(), y.floatValue(), z.floatValue(), w.floatValue());
            });
            Transformation transformation = line.getTransformation();
            Quaternionf current = this.rotationGetter.apply(transformation);
            String message = rotation.map(quaternion -> this.set(quaternion, v -> {
                current.set((Quaternionfc)v);
                return line.setTransformation(transformation);
            }, this.successKey)).orElse(this.queryKey);
            Quaternionf ored = this.rotationGetter.apply(line.getTransformation());
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, TagResolver.resolver((TagResolver[])placeholders), Formatter.number((String)"x", (Number)Float.valueOf(ored.x())), Formatter.number((String)"y", (Number)Float.valueOf(ored.y())), Formatter.number((String)"z", (Number)Float.valueOf(ored.z())), Formatter.number((String)"w", (Number)Float.valueOf(ored.w())));
            return 1;
        }, LineTargetResolver.LineType.DISPLAY);
    }
}

