/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.action;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.net.InetSocketAddress;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.thenextlvl.hologram.HologramLike;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.action.ActionType;
import net.thenextlvl.hologram.action.ActionTypes;
import net.thenextlvl.hologram.action.PageChange;
import net.thenextlvl.hologram.action.UnparsedTitle;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperTextHologramLine;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class SimpleActionTypes
implements ActionTypes {
    public static final ActionTypes INSTANCE = new SimpleActionTypes();
    private static final HologramPlugin plugin = (HologramPlugin)JavaPlugin.getPlugin(HologramPlugin.class);
    private final ActionType<String> sendActionbar = ActionType.create("send_actionbar", String.class, (line, player, actionbar) -> player.sendActionBar(PaperTextHologramLine.parse(plugin, (PaperHologram)line.getHologram(), line, actionbar, player)));
    private final ActionType<String> sendMessage = ActionType.create("send_message", String.class, (line, player, message) -> player.sendMessage(PaperTextHologramLine.parse(plugin, (PaperHologram)line.getHologram(), line, message, player)));
    private final ActionType<InetSocketAddress> transfer = ActionType.create("transfer", InetSocketAddress.class, (line, player, address) -> player.transfer(address.getHostName(), address.getPort()));
    private final ActionType<Location> teleport = ActionType.create("teleport", Location.class, (line, player, location) -> {
        if (location.isWorldLoaded()) {
            player.teleportAsync(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        } else {
            plugin.getComponentLogger().warn("Invalid target world for teleport for hologram {} ({})", (Object)line.getHologram().getName(), location);
        }
    });
    private final ActionType<Sound> playSound = ActionType.create("play_sound", Sound.class, (line, player, input) -> player.playSound(input));
    private final ActionType<String> runConsoleCommand = ActionType.create("run_console_command", String.class, (line, player, input) -> {
        String command = input.replace("<player>", player.getName());
        player.getServer().dispatchCommand((CommandSender)player.getServer().getConsoleSender(), command);
    });
    private final ActionType<String> runCommand = ActionType.create("run_command", String.class, (line, player, command) -> player.performCommand(command.replace("<player>", player.getName())));
    private final ActionType<UnparsedTitle> sendTitle = ActionType.create("send_title", UnparsedTitle.class, (line, player, title) -> {
        Component titleComponent = PaperTextHologramLine.parse(plugin, (PaperHologram)line.getHologram(), line, title.title(), player);
        Component subtitleComponent = PaperTextHologramLine.parse(plugin, (PaperHologram)line.getHologram(), line, title.subtitle(), player);
        player.showTitle(Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)title.times()));
    });
    private final ActionType<String> connect = ActionType.create("connect", String.class, (line, player, server) -> {
        ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
        dataOutput.writeUTF("Connect");
        dataOutput.writeUTF(server);
        player.sendPluginMessage((Plugin)plugin, "BungeeCord", dataOutput.toByteArray());
    });
    private final ActionType<PageChange> cyclePage = ActionType.create("cycle_page", PageChange.class, (line, player, change) -> {
        HologramLike holo = change.hologram() != null ? change.hologram() : line.getHologram();
        holo.getHologram().ifPresentOrElse(hologram -> {
            int lineIndex = change.line() != null ? change.line().intValue() : hologram.getLineIndex(line);
            hologram.getLine(lineIndex, PagedHologramLine.class).ifPresentOrElse(pagedLine -> pagedLine.cyclePage(player, change.page()), () -> plugin.getComponentLogger().warn("Line {} of hologram {} is not a paged line", (Object)(lineIndex + 1), (Object)holo.getName()));
        }, () -> plugin.getComponentLogger().warn("Hologram {} does not exist", (Object)holo.getName()));
    });
    private final ActionType<PageChange> setPage = ActionType.create("set_page", PageChange.class, (line, player, change) -> {
        HologramLike holo = change.hologram() != null ? change.hologram() : line.getHologram();
        holo.getHologram().ifPresentOrElse(hologram -> {
            int lineIndex = change.line() != null ? change.line().intValue() : hologram.getLineIndex(line);
            hologram.getLine(lineIndex, PagedHologramLine.class).ifPresentOrElse(pagedLine -> {
                int page = change.page();
                if (page >= 0 && page < pagedLine.getPageCount()) {
                    pagedLine.setPage(player, page);
                } else {
                    plugin.getComponentLogger().warn("Invalid page index for hologram {}: {}/{}", new Object[]{hologram.getName(), page, pagedLine.getPageCount()});
                }
            }, () -> plugin.getComponentLogger().warn("Line {} of hologram {} is not a paged line", (Object)(lineIndex + 1), (Object)holo.getName()));
        }, () -> plugin.getComponentLogger().warn("Hologram {} does not exist", (Object)holo.getName()));
    });

    @Override
    public ActionType<String> sendActionbar() {
        return this.sendActionbar;
    }

    @Override
    public ActionType<String> sendMessage() {
        return this.sendMessage;
    }

    @Override
    public ActionType<InetSocketAddress> transfer() {
        return this.transfer;
    }

    @Override
    public ActionType<Location> teleport() {
        return this.teleport;
    }

    @Override
    public ActionType<Sound> playSound() {
        return this.playSound;
    }

    @Override
    public ActionType<String> runConsoleCommand() {
        return this.runConsoleCommand;
    }

    @Override
    public ActionType<String> runCommand() {
        return this.runCommand;
    }

    @Override
    public ActionType<UnparsedTitle> sendTitle() {
        return this.sendTitle;
    }

    @Override
    public ActionType<String> connect() {
        return this.connect;
    }

    @Override
    public ActionType<PageChange> cyclePage() {
        return this.cyclePage;
    }

    @Override
    public ActionType<PageChange> setPage() {
        return this.setPage;
    }
}

