/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.action;

import java.time.Duration;
import java.util.EnumSet;
import java.util.Optional;
import net.thenextlvl.binder.StaticBinder;
import net.thenextlvl.hologram.Copyable;
import net.thenextlvl.hologram.action.ActionType;
import net.thenextlvl.hologram.action.ClickActionFactory;
import net.thenextlvl.hologram.action.ClickType;
import net.thenextlvl.hologram.line.HologramLine;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public interface ClickAction<T>
extends Copyable<ClickAction<T>> {
    @CheckReturnValue
    public static ClickActionFactory factory() {
        return StaticBinder.getInstance(ClickActionFactory.class.getClassLoader()).find(ClickActionFactory.class);
    }

    @Contract(pure=true)
    public ActionType<T> getActionType();

    @Contract(value=" -> new", pure=true)
    public EnumSet<ClickType> getClickTypes();

    @Contract(mutates="this")
    public boolean setClickTypes(EnumSet<ClickType> var1);

    @Contract(pure=true)
    public boolean isSupportedClickType(ClickType var1);

    @Contract(pure=true)
    public T getInput();

    @Contract(mutates="this")
    public boolean setInput(T var1);

    @Contract(pure=true)
    public @Range(from=0L, to=100L) int getChance();

    @Contract(mutates="this")
    public boolean setChance(@Range(from=0L, to=100L) int var1);

    @Contract(pure=true)
    public Optional<String> getPermission();

    @Contract(mutates="this")
    public boolean setPermission(@Nullable String var1);

    @Contract(pure=true)
    public double getCost();

    @Contract(mutates="this")
    public boolean setCost(double var1);

    @Contract(pure=true)
    public Duration getCooldown();

    @Contract(mutates="this")
    public boolean setCooldown(Duration var1);

    @Contract(pure=true)
    public boolean isOnCooldown(Player var1);

    @Contract(mutates="this")
    public boolean resetCooldown(Player var1);

    public boolean invoke(HologramLine var1, Player var2);
}

