/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.edit;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.edit.EditCommand;
import net.thenextlvl.hologram.commands.edit.LineTargetResolver;
import org.joml.Vector3f;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class EditOffsetCommand
extends EditCommand {
    private EditOffsetCommand(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        super(plugin, "offset", resolver);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin, LineTargetResolver.Builder resolver) {
        EditOffsetCommand command = new EditOffsetCommand(plugin, resolver);
        RequiredArgumentBuilder x = Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)-16.0f, (float)16.0f));
        RequiredArgumentBuilder y = Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)-16.0f, (float)16.0f));
        RequiredArgumentBuilder z = Commands.argument((String)"z", (ArgumentType)FloatArgumentType.floatArg((float)-16.0f, (float)16.0f));
        return (LiteralArgumentBuilder)command.create().then(x.then(y.then(z.executes((Command)command))));
    }

    @Override
    public int run(CommandContext<CommandSourceStack> context, LineTargetResolver resolver) throws CommandSyntaxException {
        return resolver.resolve((hologram, line, lineIndex, pageIndex, placeholders) -> {
            Float x = (Float)context.getArgument("x", Float.TYPE);
            Float y = (Float)context.getArgument("y", Float.TYPE);
            Float z = (Float)context.getArgument("z", Float.TYPE);
            Vector3f offset = new Vector3f(x.floatValue(), y.floatValue(), z.floatValue());
            String message = this.set(line.getOffset(), offset, line::setOffset, "hologram.offset");
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, placeholders);
            return 1;
        }, LineTargetResolver.LineType.ENTITY);
    }
}

