/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.adapters.action;

import java.time.Duration;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.title.Title;
import net.thenextlvl.hologram.action.ActionType;
import net.thenextlvl.hologram.action.ClickAction;
import net.thenextlvl.hologram.action.ClickType;
import net.thenextlvl.hologram.action.UnparsedTitle;
import net.thenextlvl.hologram.adapters.action.ActionTypeAdapter;
import net.thenextlvl.hologram.adapters.action.KeyAdapter;
import net.thenextlvl.hologram.adapters.action.LazyLocationAdapter;
import net.thenextlvl.hologram.adapters.action.SoundAdapter;
import net.thenextlvl.hologram.adapters.action.TitleTimesAdapter;
import net.thenextlvl.hologram.adapters.action.UnparsedTitleAdapter;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.serialization.adapters.EnumAdapter;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.Tag;
import org.bukkit.Location;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ClickActionAdapter
implements TagAdapter<ClickAction<?>> {
    private final NBT context = NBT.builder().registerTypeHierarchyAdapter((Class<?>)ActionType.class, new ActionTypeAdapter()).registerTypeHierarchyAdapter((Class<?>)ClickType.class, new EnumAdapter<ClickType>(ClickType.class)).registerTypeHierarchyAdapter((Class<?>)Key.class, new KeyAdapter()).registerTypeHierarchyAdapter((Class<?>)Location.class, new LazyLocationAdapter()).registerTypeHierarchyAdapter((Class<?>)Sound.Source.class, new EnumAdapter<Sound.Source>(Sound.Source.class)).registerTypeHierarchyAdapter((Class<?>)Sound.class, new SoundAdapter()).registerTypeHierarchyAdapter((Class<?>)Title.Times.class, new TitleTimesAdapter()).registerTypeHierarchyAdapter((Class<?>)UnparsedTitle.class, new UnparsedTitleAdapter()).build();

    @Override
    public ClickAction<?> deserialize(Tag tag, TagDeserializationContext ignored) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        ActionType actionType = this.context.deserialize((Tag)root.get("actionType"), ActionType.class);
        EnumSet clickTypes = root.getAsList("clickTypes").stream().map(tag1 -> this.context.deserialize((Tag)tag1, ClickType.class)).collect(Collectors.toCollection(() -> EnumSet.noneOf(ClickType.class)));
        Object input = this.context.deserialize((Tag)root.get("input"), actionType.type());
        ClickAction action = ClickAction.factory().create(actionType, clickTypes, input);
        root.optional("chance").map(Tag::getAsInt).ifPresent(action::setChance);
        root.optional("cooldown").map(Tag::getAsLong).map(Duration::ofMillis).ifPresent(action::setCooldown);
        root.optional("cost").map(Tag::getAsDouble).ifPresent(action::setCost);
        root.optional("permission").map(Tag::getAsString).ifPresent(action::setPermission);
        return action;
    }

    @Override
    public Tag serialize(ClickAction<?> action, TagSerializationContext ignored) throws ParserException {
        CompoundTag.Builder builder = CompoundTag.builder();
        action.getPermission().ifPresent(permission -> builder.put("permission", (String)permission));
        if (action.getCost() != 0.0) {
            builder.put("cost", action.getCost());
        }
        if (!action.getCooldown().isZero()) {
            builder.put("cooldown", (Number)action.getCooldown().toMillis());
        }
        builder.put("actionType", this.context.serialize(action.getActionType()));
        ListTag.Builder types = ListTag.builder().contentType((byte)8);
        action.getClickTypes().forEach(clickType -> types.add(this.context.serialize(clickType)));
        builder.put("clickTypes", types.build());
        builder.put("input", this.context.serialize(action.getInput()));
        builder.put("chance", (Number)action.getChance());
        return builder.build();
    }
}

