/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.action;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.net.InetSocketAddress;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import net.thenextlvl.hologram.action.ActionType;
import net.thenextlvl.hologram.action.ActionTypes;
import net.thenextlvl.hologram.action.UnparsedTitle;
import net.thenextlvl.hologram.line.PagedHologramLine;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

final class SimpleActionTypes
implements ActionTypes {
    public static final ActionTypes INSTANCE = new SimpleActionTypes();
    private static final JavaPlugin plugin = JavaPlugin.getProvidingPlugin(SimpleActionTypes.class);
    private final ActionType<String> sendActionbar = ActionType.create("send_actionbar", String.class, (line, player, actionbar) -> {
        TagResolver.Single placeholder = Placeholder.parsed((String)"player", (String)player.getName());
        Component message = MiniMessage.miniMessage().deserialize(actionbar, (TagResolver)placeholder);
        player.sendActionBar(message);
    });
    private final ActionType<String> sendMessage = ActionType.create("send_message", String.class, (line, player, message) -> {
        TagResolver.Single placeholder = Placeholder.parsed((String)"player", (String)player.getName());
        player.sendMessage(MiniMessage.miniMessage().deserialize(message, (TagResolver)placeholder));
    });
    private final ActionType<InetSocketAddress> transfer = ActionType.create("transfer", InetSocketAddress.class, (line, player, address) -> player.transfer(address.getHostName(), address.getPort()));
    private final ActionType<Location> teleport = ActionType.create("teleport", Location.class, (line, player, location) -> {
        if (location.isWorldLoaded()) {
            player.teleportAsync(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        } else {
            plugin.getComponentLogger().warn("Invalid target world for teleport for hologram {} ({})", (Object)line.getHologram().getName(), location);
        }
    });
    private final ActionType<Sound> playSound = ActionType.create("play_sound", Sound.class, (line, player, input) -> player.playSound(input));
    private final ActionType<String> runConsoleCommand = ActionType.create("run_console_command", String.class, (line, player, input) -> {
        String command = input.replace("<player>", player.getName());
        player.getServer().dispatchCommand((CommandSender)player.getServer().getConsoleSender(), command);
    });
    private final ActionType<String> runCommand = ActionType.create("run_command", String.class, (line, player, command) -> player.performCommand(command.replace("<player>", player.getName())));
    private final ActionType<UnparsedTitle> sendTitle = ActionType.create("send_title", UnparsedTitle.class, (line, player, title) -> {
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Component titleComponent = miniMessage.deserialize((Object)title.title());
        Component subtitleComponent = miniMessage.deserialize((Object)title.subtitle());
        player.showTitle(Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)title.times()));
    });
    private final ActionType<String> connect = ActionType.create("connect", String.class, (line, player, server) -> {
        ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
        dataOutput.writeUTF("Connect");
        dataOutput.writeUTF(server);
        player.sendPluginMessage((Plugin)plugin, "BungeeCord", dataOutput.toByteArray());
    });
    private final ActionType<Integer> cyclePage = ActionType.create("cycle_page", Integer.class, (line, player, amount) -> {
        if (line instanceof PagedHologramLine) {
            PagedHologramLine pagedLine = (PagedHologramLine)line;
            pagedLine.cyclePage(player, (int)amount);
        }
    });
    private final ActionType<Integer> setPage = ActionType.create("set_page", Integer.class, (line, player, page) -> {
        if (!(line instanceof PagedHologramLine)) {
            return;
        }
        PagedHologramLine pagedLine = (PagedHologramLine)line;
        if (page >= 0 && page < pagedLine.getPageCount()) {
            pagedLine.setPage(player, (int)page);
        } else {
            plugin.getComponentLogger().warn("Invalid page index for hologram {}: {}/{}", new Object[]{line.getHologram().getName(), page, pagedLine.getPageCount()});
        }
    });

    SimpleActionTypes() {
    }

    @Override
    public ActionType<String> sendActionbar() {
        return this.sendActionbar;
    }

    @Override
    public ActionType<String> sendMessage() {
        return this.sendMessage;
    }

    @Override
    public ActionType<InetSocketAddress> transfer() {
        return this.transfer;
    }

    @Override
    public ActionType<Location> teleport() {
        return this.teleport;
    }

    @Override
    public ActionType<Sound> playSound() {
        return this.playSound;
    }

    @Override
    public ActionType<String> runConsoleCommand() {
        return this.runConsoleCommand;
    }

    @Override
    public ActionType<String> runCommand() {
        return this.runCommand;
    }

    @Override
    public ActionType<UnparsedTitle> sendTitle() {
        return this.sendTitle;
    }

    @Override
    public ActionType<String> connect() {
        return this.connect;
    }

    @Override
    public ActionType<Integer> cyclePage() {
        return this.cyclePage;
    }

    @Override
    public ActionType<Integer> setPage() {
        return this.setPage;
    }
}

