/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperBlockHologramLine;
import net.thenextlvl.hologram.models.line.PaperEntityHologramLine;
import net.thenextlvl.hologram.models.line.PaperHologramLine;
import net.thenextlvl.hologram.models.line.PaperItemHologramLine;
import net.thenextlvl.hologram.models.line.PaperStaticHologramLine;
import net.thenextlvl.hologram.models.line.PaperTextHologramLine;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PaperPagedHologramLine
extends PaperHologramLine
implements PagedHologramLine {
    private final List<PaperStaticHologramLine<?>> pages = new CopyOnWriteArrayList();
    private final Map<Player, Integer> currentPageIndex = new ConcurrentHashMap<Player, Integer>();
    private final Random random = new Random();
    private final AtomicBoolean cycling = new AtomicBoolean(false);
    private final AtomicLong nextCycleTime = new AtomicLong(0L);
    private volatile Duration interval = Duration.ofSeconds(2L);
    private volatile boolean paused = false;
    private volatile boolean randomOrder = false;

    public PaperPagedHologramLine(PaperHologram hologram) {
        super(hologram);
    }

    @Override
    public Optional<Entity> getEntity(Player player) {
        return this.getCurrentPage(player).flatMap(page -> page.getEntity(player));
    }

    @Override
    public <T> Optional<T> getEntity(Player player, Class<T> type) {
        return this.getEntity(player).filter(type::isInstance).map(type::cast);
    }

    @Override
    public Class<? extends Entity> getEntityClass() {
        return Entity.class;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.MARKER;
    }

    @Override
    public LineType getType() {
        return LineType.PAGED;
    }

    @Override
    public boolean isPart(Entity entity) {
        return this.pages.stream().anyMatch(page -> page.isPart(entity));
    }

    @Override
    public List<HologramLine> getPages() {
        return List.copyOf(this.pages);
    }

    @Override
    public Optional<HologramLine> getPage(int index) {
        if (index < 0 || index >= this.pages.size()) {
            return Optional.empty();
        }
        return Optional.of((HologramLine)this.pages.get(index));
    }

    @Override
    public <T extends HologramLine> Optional<T> getPage(int index, Class<T> type) {
        return this.getPage(index).filter(type::isInstance).map(type::cast);
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public int getPageIndex(HologramLine line) {
        int n;
        if (line instanceof PaperStaticHologramLine) {
            PaperStaticHologramLine page = (PaperStaticHologramLine)line;
            n = this.pages.indexOf(page);
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public TextHologramLine addTextPage() {
        PaperTextHologramLine page = new PaperTextHologramLine(this.getHologram(), this);
        this.pages.add(page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public ItemHologramLine addItemPage() {
        PaperItemHologramLine page = new PaperItemHologramLine(this.getHologram(), this);
        this.pages.add(page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public BlockHologramLine addBlockPage() {
        PaperBlockHologramLine page = new PaperBlockHologramLine(this.getHologram(), this);
        this.pages.add(page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public EntityHologramLine addEntityPage(EntityType entityType) throws IllegalArgumentException {
        PaperEntityHologramLine page = new PaperEntityHologramLine(this.getHologram(), this, entityType);
        this.pages.add(page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public boolean removePage(int index) {
        if (index < 0 || index >= this.pages.size()) {
            return false;
        }
        PaperStaticHologramLine<?> removed = this.pages.remove(index);
        removed.despawn();
        return true;
    }

    @Override
    public boolean removePage(HologramLine page) {
        if (!(page instanceof PaperStaticHologramLine)) {
            return false;
        }
        PaperStaticHologramLine paperPage = (PaperStaticHologramLine)page;
        boolean removed = this.pages.remove(paperPage);
        if (removed) {
            paperPage.despawn();
        }
        return removed;
    }

    @Override
    public void clearPages() {
        this.pages.forEach(PaperStaticHologramLine::despawn);
        this.pages.clear();
        this.currentPageIndex.clear();
        this.stopCycleTask();
    }

    @Override
    public boolean swapPages(int first, int second) {
        if (first < 0 || first >= this.pages.size() || second < 0 || second >= this.pages.size()) {
            return false;
        }
        Collections.swap(this.pages, first, second);
        this.getHologram().updateHologram();
        return true;
    }

    @Override
    public boolean movePage(int from, int to) {
        if (from < 0 || from >= this.pages.size() || to < 0 || to >= this.pages.size()) {
            return false;
        }
        PaperStaticHologramLine<?> page = this.pages.remove(from);
        this.pages.add(to, page);
        this.getHologram().updateHologram();
        return true;
    }

    @Override
    public TextHologramLine setTextPage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.pages.size());
        }
        PaperTextHologramLine page = new PaperTextHologramLine(this.getHologram(), this);
        this.pages.set(index, page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public ItemHologramLine setItemPage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.pages.size());
        }
        PaperItemHologramLine page = new PaperItemHologramLine(this.getHologram(), this);
        this.pages.set(index, page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public BlockHologramLine setBlockPage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.pages.size());
        }
        PaperBlockHologramLine page = new PaperBlockHologramLine(this.getHologram(), this);
        this.pages.set(index, page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public EntityHologramLine setEntityPage(int index, EntityType entityType) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (index < 0 || index >= this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.pages.size());
        }
        PaperEntityHologramLine page = new PaperEntityHologramLine(this.getHologram(), this, entityType);
        this.pages.set(index, page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public TextHologramLine insertTextPage(int index) {
        if (index < 0 || index > this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.pages.size());
        }
        PaperTextHologramLine page = new PaperTextHologramLine(this.getHologram(), this);
        this.pages.add(index, page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public ItemHologramLine insertItemPage(int index) {
        if (index < 0 || index > this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.pages.size());
        }
        PaperItemHologramLine page = new PaperItemHologramLine(this.getHologram(), this);
        this.pages.add(index, page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public BlockHologramLine insertBlockPage(int index) {
        if (index < 0 || index > this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.pages.size());
        }
        PaperBlockHologramLine page = new PaperBlockHologramLine(this.getHologram(), this);
        this.pages.add(index, page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public EntityHologramLine insertEntityPage(int index, EntityType entityType) throws IllegalArgumentException {
        if (index < 0 || index > this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.pages.size());
        }
        PaperEntityHologramLine page = new PaperEntityHologramLine(this.getHologram(), this, entityType);
        this.pages.add(index, page);
        this.getHologram().updateHologram();
        return page;
    }

    @Override
    public Duration getInterval() {
        return this.interval;
    }

    @Override
    public PagedHologramLine setInterval(Duration interval) {
        Preconditions.checkArgument((boolean)interval.isPositive(), (Object)"Interval must be bigger than zero");
        this.interval = interval;
        this.nextCycleTime.set(System.currentTimeMillis() + interval.toMillis());
        return this;
    }

    @Override
    public boolean isRandomOrder() {
        return this.randomOrder;
    }

    @Override
    public PagedHologramLine setRandomOrder(boolean random) {
        this.randomOrder = random;
        return this;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public PagedHologramLine setPaused(boolean paused) {
        this.paused = paused;
        if (paused) {
            this.stopCycleTask();
        } else {
            this.startCycleTask();
        }
        return this;
    }

    public Optional<PaperStaticHologramLine<?>> getCurrentPage(Player player) {
        Integer index = this.currentPageIndex.getOrDefault(player, 0);
        return this.getPage(index).map(hologramLine -> (PaperStaticHologramLine)hologramLine);
    }

    public int getCurrentPageIndex(Player player) {
        return this.currentPageIndex.getOrDefault(player, 0);
    }

    @Override
    public double getHeight(Player player) {
        return this.getCurrentPage(player).map(page -> page.getHeight(player)).orElse(0.0);
    }

    @Override
    public double getOffsetBefore(Player player) {
        return this.getCurrentPage(player).map(page -> page.getOffsetBefore(player)).orElse(0.0);
    }

    @Override
    public double getOffsetAfter(Player player) {
        return this.getCurrentPage(player).map(page -> page.getOffsetAfter(player)).orElse(0.0);
    }

    @Override
    public CompletableFuture<@Nullable Entity> spawn(Player player, double offset) {
        if (this.pages.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        this.currentPageIndex.compute(player, (ignored, index) -> index == null || index >= this.pages.size() ? 0 : index);
        PaperStaticHologramLine page = this.getCurrentPage(player).orElseGet(this.pages::getFirst);
        this.startCycleTask();
        return page.spawn(player, offset);
    }

    @Override
    public CompletableFuture<Void> despawn() {
        this.stopCycleTask();
        this.currentPageIndex.clear();
        CompletableFuture[] futures = (CompletableFuture[])this.pages.stream().map(PaperStaticHologramLine::despawn).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    @Override
    public CompletableFuture<Void> despawn(Player player) {
        this.currentPageIndex.remove(player);
        if (this.currentPageIndex.isEmpty()) {
            this.stopCycleTask();
        }
        CompletableFuture[] futures = (CompletableFuture[])this.pages.stream().map(page -> page.despawn(player)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    @Override
    public CompletableFuture<Void> teleportRelative(Location previous, Location location) {
        return CompletableFuture.allOf((CompletableFuture[])this.pages.stream().map(page -> page.teleportRelative(previous, location)).toArray(CompletableFuture[]::new));
    }

    @Override
    public void invalidate(Entity entity) {
        this.pages.forEach(page -> page.invalidate(entity));
    }

    private CompletableFuture<Void> cyclePage(Player player, double offset) {
        if (this.pages.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        int oldIndex = this.currentPageIndex.getOrDefault(player, 0);
        PaperStaticHologramLine<?> oldPage = this.pages.size() > oldIndex ? this.pages.get(oldIndex) : null;
        int newIndex = this.randomOrder ? this.random.nextInt(this.pages.size()) : (oldIndex + 1) % this.pages.size();
        PaperStaticHologramLine<?> newPage = this.pages.get(newIndex);
        this.currentPageIndex.put(player, newIndex);
        if (oldPage != null && newPage.adoptEntity(oldPage, player, offset)) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Object> despawn = oldPage != null ? oldPage.despawn(player) : CompletableFuture.completedFuture(null);
        return despawn.thenCompose(v -> newPage.spawn(player, offset).thenAccept(e -> {}));
    }

    private void startCycleTask() {
        if (this.paused || this.pages.size() <= 1) {
            return;
        }
        if (!this.getHologram().getPlugin().hologramTickPool().register(this)) {
            return;
        }
        this.nextCycleTime.set(System.currentTimeMillis() + this.interval.toMillis());
    }

    private void stopCycleTask() {
        if (this.getHologram().getPlugin().hologramTickPool().unregister(this)) {
            this.nextCycleTime.set(0L);
        }
    }

    public void tickCycle(long now) {
        if (now < this.nextCycleTime.get()) {
            return;
        }
        if (!this.cycling.compareAndSet(false, true)) {
            return;
        }
        this.cycleAllPlayers().whenComplete((v, t) -> {
            long elapsed = System.currentTimeMillis() - now;
            this.nextCycleTime.set(System.currentTimeMillis() + Math.max(0L, this.interval.toMillis() - elapsed));
            this.cycling.set(false);
        });
    }

    private CompletableFuture<Void> cycleAllPlayers() {
        CompletableFuture[] futures = (CompletableFuture[])this.currentPageIndex.keySet().stream().map(player -> this.cyclePage((Player)player, this.calculateOffset((Player)player))).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenRun(() -> this.getHologram().updateHologram());
    }

    private double calculateOffset(Player player) {
        List<HologramLine> lines = this.getHologram().getLines().toList();
        double offset = 0.0;
        for (int i = lines.size() - 1; i >= 0; --i) {
            PaperHologramLine line = (PaperHologramLine)lines.get(i);
            if (line == this) {
                return offset;
            }
            offset += 0.05 + line.getHeight(player) + line.getOffsetAfter(player);
        }
        return offset;
    }

    public void addPage(PaperStaticHologramLine<?> hologramLine) {
        hologramLine.parentLine = this;
        this.pages.add(hologramLine);
    }
}

