/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.line;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public interface PagedHologramLine
extends HologramLine {
    @Contract(pure=true)
    public @Unmodifiable List<HologramLine> getPages();

    @Contract(pure=true)
    public Optional<HologramLine> getPage(int var1);

    @Contract(pure=true)
    public <T extends HologramLine> Optional<T> getPage(int var1, Class<T> var2);

    @Contract(pure=true)
    public int getPageCount();

    @Contract(pure=true)
    public int getPageIndex(HologramLine var1);

    @Contract(value=" -> new", mutates="this")
    public TextHologramLine addTextPage();

    @Contract(value=" -> new", mutates="this")
    public ItemHologramLine addItemPage();

    @Contract(value=" -> new", mutates="this")
    public BlockHologramLine addBlockPage();

    @Contract(value="_ -> new", mutates="this")
    public EntityHologramLine addEntityPage(EntityType var1) throws IllegalArgumentException;

    @Contract(mutates="this")
    public boolean removePage(int var1);

    @Contract(mutates="this")
    public boolean removePage(HologramLine var1);

    @Contract(mutates="this")
    public void clearPages();

    @Contract(mutates="this")
    public boolean swapPages(int var1, int var2);

    @Contract(mutates="this")
    public boolean movePage(int var1, int var2);

    @Contract(value="_ -> new", mutates="this")
    public TextHologramLine setTextPage(int var1) throws IndexOutOfBoundsException;

    @Contract(value="_ -> new", mutates="this")
    public ItemHologramLine setItemPage(int var1) throws IndexOutOfBoundsException;

    @Contract(value="_ -> new", mutates="this")
    public BlockHologramLine setBlockPage(int var1) throws IndexOutOfBoundsException;

    @Contract(value="_, _ -> new", mutates="this")
    public EntityHologramLine setEntityPage(int var1, EntityType var2) throws IllegalArgumentException, IndexOutOfBoundsException;

    @Contract(value="_ -> new", mutates="this")
    public TextHologramLine insertTextPage(int var1) throws IndexOutOfBoundsException;

    @Contract(value="_ -> new", mutates="this")
    public ItemHologramLine insertItemPage(int var1) throws IndexOutOfBoundsException;

    @Contract(value="_ -> new", mutates="this")
    public BlockHologramLine insertBlockPage(int var1) throws IndexOutOfBoundsException;

    @Contract(value="_, _ -> new", mutates="this")
    public EntityHologramLine insertEntityPage(int var1, EntityType var2) throws IllegalArgumentException, IndexOutOfBoundsException;

    @Contract(pure=true)
    public Duration getInterval();

    @Contract(value="_ -> this", mutates="this")
    public PagedHologramLine setInterval(Duration var1) throws IllegalArgumentException;

    @Contract(pure=true)
    public boolean isRandomOrder();

    @Contract(value="_ -> this", mutates="this")
    public PagedHologramLine setRandomOrder(boolean var1);

    @Contract(pure=true)
    public boolean isPaused();

    @Contract(value="_ -> this", mutates="this")
    public PagedHologramLine setPaused(boolean var1);
}

