/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.translation;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Locale;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.arguments.LocaleArgumentType;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.commands.translation.HologramTranslationCommand;
import net.thenextlvl.hologram.locale.LanguageTags;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramTranslationAddCommand
extends SimpleCommand {
    private HologramTranslationAddCommand(HologramPlugin plugin) {
        super(plugin, "add", "holograms.command.translation.add");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramTranslationAddCommand command = new HologramTranslationAddCommand(plugin);
        RequiredArgumentBuilder locale = Commands.argument((String)"locale", (ArgumentType)new LocaleArgumentType(plugin, false));
        RequiredArgumentBuilder translation = Commands.argument((String)"translation", (ArgumentType)StringArgumentType.greedyString());
        return (LiteralArgumentBuilder)command.create().then(HologramTranslationCommand.translationKeyArgument(plugin).then(locale.then(translation.executes((Command)command))));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Locale locale = (Locale)context.getArgument("locale", Locale.class);
        String key = (String)context.getArgument("translation key", String.class);
        String translation = (String)context.getArgument("translation", String.class);
        boolean success = this.plugin.translations().override(key, locale, translation);
        if (success) {
            this.plugin.updateHologramTextLines(null);
            this.plugin.translations().save(locale);
        }
        String message = success ? "hologram.translation.added" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"locale", (String)LanguageTags.getLanguageName(locale)), Placeholder.parsed((String)"key", (String)key)});
        return success ? 1 : 0;
    }
}

