/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.suggestions;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.commands.suggestions.LineSuggestionProvider;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PageSuggestionProvider
implements SuggestionProvider<CommandSourceStack> {
    public static final PageSuggestionProvider INSTANCE = new PageSuggestionProvider();

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        int lineIndex;
        Hologram hologram = (Hologram)context.getLastChild().getArgument("hologram", Hologram.class);
        Optional<PagedHologramLine> line = hologram.getLine(lineIndex = (Integer)context.getLastChild().getArgument("line", Integer.TYPE) - 1, PagedHologramLine.class);
        if (line.isEmpty()) {
            return builder.buildFuture();
        }
        PagedHologramLine pagedLine = line.get();
        List<HologramLine> pages = pagedLine.getPages();
        for (int index = 1; index <= pages.size(); ++index) {
            String page = String.valueOf(index);
            if (!page.contains(builder.getRemaining())) continue;
            builder.suggest(page, LineSuggestionProvider.getTooltip(pages.get(index - 1)));
        }
        return builder.buildFuture();
    }
}

