/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.page;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.commands.suggestions.LineSuggestionProvider;
import net.thenextlvl.hologram.commands.suggestions.PageSuggestionProvider;
import net.thenextlvl.hologram.line.PagedHologramLine;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramPageMoveCommand
extends SimpleCommand {
    private HologramPageMoveCommand(HologramPlugin plugin) {
        super(plugin, "move", "holograms.command.page.move");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramPageMoveCommand command = new HologramPageMoveCommand(plugin);
        RequiredArgumentBuilder line = Commands.argument((String)"line", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)LineSuggestionProvider.PAGED_ONLY);
        RequiredArgumentBuilder from = Commands.argument((String)"from", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)PageSuggestionProvider.INSTANCE);
        RequiredArgumentBuilder to = Commands.argument((String)"to", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((SuggestionProvider)PageSuggestionProvider.INSTANCE);
        return (LiteralArgumentBuilder)command.create().then(HologramCommand.hologramArgument(plugin, true).then(line.then(from.then(to.executes((Command)command)))));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        int lineIndex = (Integer)context.getArgument("line", Integer.TYPE) - 1;
        Integer from = (Integer)context.getArgument("from", Integer.TYPE);
        Integer to = (Integer)context.getArgument("to", Integer.TYPE);
        Optional<PagedHologramLine> line = hologram.getLine(lineIndex, PagedHologramLine.class);
        if (line.isEmpty()) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "hologram.type.paged");
            return 0;
        }
        boolean success = line.get().movePage(from - 1, to - 1);
        String message = success ? "hologram.page.move" : "hologram.page.move.failed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1)), Formatter.number((String)"from", (Number)from), Formatter.number((String)"to", (Number)to)});
        return success ? 1 : 0;
    }
}

