/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.commands.suggestions.PermissionSuggestionProvider;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramViewPermissionCommand
extends SimpleCommand {
    private HologramViewPermissionCommand(HologramPlugin plugin) {
        super(plugin, "view-permission", "holograms.command.view-permission");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramViewPermissionCommand command = new HologramViewPermissionCommand(plugin);
        RequiredArgumentBuilder permission = Commands.argument((String)"permission", (ArgumentType)StringArgumentType.string()).suggests(new PermissionSuggestionProvider(plugin));
        return (LiteralArgumentBuilder)command.create().then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)HologramCommand.hologramArgument(plugin).then(Commands.literal((String)"remove").executes(command::set))).then(permission.executes(command::set))).executes((Command)command));
    }

    private int set(CommandContext<CommandSourceStack> context) {
        String viewPermission;
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        boolean success = hologram.setViewPermission(viewPermission = (String)this.tryGetArgument(context, "permission", String.class).orElse(null));
        String message = !success ? "nothing.changed" : (viewPermission != null ? "hologram.view-permission.set" : "hologram.view-permission.removed");
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Placeholder.unparsed((String)"permission", (String)String.valueOf(viewPermission))});
        return success ? 1 : 0;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Hologram hologram = (Hologram)context.getArgument("hologram", Hologram.class);
        String permission = hologram.getViewPermission().orElse(null);
        String message = permission != null ? "hologram.view-permission" : "hologram.view-permission.none";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Placeholder.unparsed((String)"permission", (String)String.valueOf(permission))});
        return 1;
    }
}

