/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.action;

import java.time.Duration;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.thenextlvl.hologram.action.ActionType;
import net.thenextlvl.hologram.action.ClickAction;
import net.thenextlvl.hologram.action.ClickType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

final class SimpleClickAction<T>
implements ClickAction<T> {
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final ActionType<T> actionType;
    private EnumSet<ClickType> clickTypes;
    private T input;
    private @Range(from=0L, to=100L) int chance = 100;
    private Duration cooldown = Duration.ZERO;
    private @Nullable String permission = null;

    public SimpleClickAction(ActionType<T> actionType, EnumSet<ClickType> clickTypes, T input) {
        this.actionType = actionType;
        this.clickTypes = clickTypes;
        this.input = input;
    }

    @Override
    public ActionType<T> getActionType() {
        return this.actionType;
    }

    @Override
    public EnumSet<ClickType> getClickTypes() {
        return this.clickTypes;
    }

    @Override
    public boolean setClickTypes(EnumSet<ClickType> clickTypes) {
        if (Objects.equals(this.clickTypes, clickTypes)) {
            return false;
        }
        this.clickTypes = clickTypes;
        return true;
    }

    @Override
    public boolean isSupportedClickType(ClickType type) {
        return this.clickTypes.contains((Object)type);
    }

    @Override
    public T getInput() {
        return this.input;
    }

    @Override
    public boolean setInput(T input) {
        if (Objects.equals(this.input, input)) {
            return false;
        }
        this.input = input;
        return true;
    }

    @Override
    public @Range(from=0L, to=100L) int getChance() {
        return this.chance;
    }

    @Override
    public boolean setChance(@Range(from=0L, to=100L) int chance) {
        if (this.chance == chance) {
            return false;
        }
        this.chance = Math.clamp((long)chance, 0, 100);
        return true;
    }

    @Override
    public @Nullable String getPermission() {
        return this.permission;
    }

    @Override
    public boolean setPermission(@Nullable String permission) {
        if (Objects.equals(this.permission, permission)) {
            return false;
        }
        this.permission = permission;
        return true;
    }

    @Override
    public Duration getCooldown() {
        return this.cooldown;
    }

    @Override
    public boolean setCooldown(Duration cooldown) {
        if (Objects.equals(this.cooldown, cooldown)) {
            return false;
        }
        this.cooldown = cooldown;
        return true;
    }

    @Override
    public boolean isOnCooldown(Player player) {
        return this.cooldown.isPositive() && this.cooldowns.computeIfPresent(player.getUniqueId(), (ignored, lastUsed) -> {
            if (System.currentTimeMillis() - this.cooldown.toMillis() > lastUsed) {
                return null;
            }
            return lastUsed;
        }) != null;
    }

    @Override
    public boolean resetCooldown(Player player) {
        return this.cooldowns.remove(player.getUniqueId()) != null;
    }

    @Override
    public boolean canInvoke(Player player) {
        return (this.permission == null || player.hasPermission(this.permission)) && !this.isOnCooldown(player);
    }

    @Override
    public boolean invoke(Player player) {
        if (!this.canInvoke(player)) {
            return false;
        }
        if (this.cooldown.isPositive()) {
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
        if (ThreadLocalRandom.current().nextInt(100) > this.chance) {
            return false;
        }
        this.actionType.action().invoke(player, this.input);
        return true;
    }
}

