/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.StaticHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperHologramLine;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PaperStaticHologramLine<E extends Entity>
extends PaperHologramLine
implements StaticHologramLine {
    protected final Map<Player, E> entities = new ConcurrentHashMap<Player, E>();
    protected volatile @Nullable PagedHologramLine parentLine;
    protected volatile @Nullable TextColor glowColor = null;
    protected volatile Class<E> entityClass;
    protected volatile EntityType entityType;
    protected volatile boolean glowing = false;

    public PaperStaticHologramLine(PaperHologram hologram, @Nullable PagedHologramLine parentLine, EntityType entityType) throws IllegalArgumentException {
        super(hologram);
        Preconditions.checkArgument((entityType.getEntityClass() != null ? 1 : 0) != 0, (String)"Entity type %s is not spawnable", (Object)entityType);
        this.entityType = entityType;
        this.entityClass = entityType.getEntityClass();
        this.parentLine = parentLine;
    }

    @Override
    public Optional<TextColor> getGlowColor() {
        return Optional.ofNullable(this.glowColor);
    }

    @Override
    public StaticHologramLine setGlowColor(@Nullable TextColor color) {
        return (StaticHologramLine)this.set(this.glowColor, color, () -> {
            this.glowColor = color;
            this.updateGlowColor(color);
        }, false);
    }

    @Override
    public boolean isGlowing() {
        return this.glowing;
    }

    @Override
    public StaticHologramLine setGlowing(boolean glowing) {
        return (StaticHologramLine)this.set(this.glowing, glowing, () -> {
            this.glowing = glowing;
            this.forEachEntity(entity -> entity.setGlowing(glowing));
        }, false);
    }

    protected abstract void updateGlowColor(@Nullable TextColor var1);

    @Override
    public Class<? extends Entity> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public Optional<Entity> getEntity(Player player) {
        return Optional.ofNullable((Entity)this.entities.get(player));
    }

    @Override
    public <T> Optional<T> getEntity(Player player, Class<T> type) {
        return this.getEntity(player).filter(type::isInstance).map(type::cast);
    }

    @Override
    public Optional<PagedHologramLine> getParentLine() {
        return Optional.ofNullable(this.parentLine);
    }

    @Override
    public CompletableFuture<Void> despawn() {
        CompletableFuture[] futures = (CompletableFuture[])this.entities.values().stream().map(e -> this.getHologram().getPlugin().supply((Entity)e, () -> ((Entity)e).remove())).toArray(CompletableFuture[]::new);
        this.entities.clear();
        return CompletableFuture.allOf(futures);
    }

    @Override
    public CompletableFuture<@Nullable Void> despawn(Player player) {
        Entity entity = (Entity)this.entities.remove(player);
        if (entity != null) {
            return this.getHologram().getPlugin().supply(entity, () -> ((Entity)entity).remove());
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<@Nullable Entity> spawn(Player player, double offset) {
        Entity existing = (Entity)this.entities.get(player);
        Location location = this.mutateSpawnLocation(this.getHologram().getLocation().add(0.0, offset, 0.0));
        if (existing != null && existing.isValid()) {
            return this.getHologram().getPlugin().supply(existing, () -> {
                existing.teleportAsync(location);
                this.preSpawn(existing, player);
                return existing;
            });
        }
        return this.getHologram().getPlugin().supply(location, () -> {
            Entity spawn = location.getWorld().spawn(location, this.entityClass, false, e -> this.preSpawn(e, player));
            this.getHologram().getPlugin().supply((Entity)player, () -> player.showEntity((Plugin)this.getHologram().getPlugin(), spawn));
            this.entities.put(player, spawn);
            return spawn;
        });
    }

    protected Location mutateSpawnLocation(Location location) {
        return location;
    }

    protected void preSpawn(E entity, Player player) {
        this.updateTeamOptions(player, (Entity)entity);
        entity.setPersistent(false);
        entity.setVisibleByDefault(false);
        entity.setGlowing(this.glowing);
        this.updateGlowColor(this.glowColor);
    }

    @Override
    public CompletableFuture<Void> teleportRelative(Location previous, Location location) {
        return CompletableFuture.allOf((CompletableFuture[])this.entities.values().stream().filter(Entity::isValid).map(entity -> entity.teleportAsync(new Location(location.getWorld(), location.getX() + entity.getX() - previous.getX(), location.getY() + entity.getY() - previous.getY(), location.getZ() + entity.getZ() - previous.getZ(), location.getYaw(), location.getPitch()))).toArray(CompletableFuture[]::new));
    }

    @Override
    public boolean isPart(Entity entity) {
        return this.entityClass.isInstance(entity) && this.entities.containsValue(this.entityClass.cast(entity));
    }

    @Override
    public void invalidate(Entity entity) {
        Player owner = this.remove(entity);
        if (owner == null) {
            return;
        }
        Team team = owner.getScoreboard().getTeam(entity.getScoreboardEntryName());
        if (team != null) {
            team.unregister();
        }
    }

    private @Nullable Player remove(Entity entity) {
        Iterator<Map.Entry<Player, E>> iterator = this.entities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Player, E> entry = iterator.next();
            if (!((Entity)entry.getValue()).equals((Object)entity)) continue;
            iterator.remove();
            return entry.getKey();
        }
        return null;
    }

    public boolean adoptEntity(PaperStaticHologramLine<?> oldPage, Player player, double offset) {
        Entity entity = (Entity)oldPage.entities.get(player);
        if (!this.entityClass.isInstance(entity)) {
            return false;
        }
        oldPage.entities.remove(player);
        this.entities.put(player, entity);
        this.getHologram().getPlugin().supply(entity, () -> {
            entity.teleportAsync(this.mutateSpawnLocation(this.getHologram().getLocation().add(0.0, offset, 0.0)));
            this.preSpawn(entity, player);
        });
        return true;
    }

    protected final void updateTeamOptions(Player player, Entity entity) {
        if (HologramPlugin.RUNNING_FOLIA) {
            return;
        }
        Team team = this.getSettingsTeam(player, entity);
        team.color((NamedTextColor)this.getGlowColor().map(NamedTextColor::nearestTo).orElse(null));
        team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
    }

    private Team getSettingsTeam(Player player, Entity entity) {
        Team settings = player.getScoreboard().getTeam(entity.getScoreboardEntryName());
        if (settings != null) {
            return settings;
        }
        settings = player.getScoreboard().registerNewTeam(entity.getScoreboardEntryName());
        settings.addEntry(entity.getScoreboardEntryName());
        return settings;
    }

    public Map<Player, E> getEntities() {
        return this.entities;
    }

    public void forEachEntity(Consumer<E> consumer) {
        this.entities.values().forEach(consumer);
    }
}

