/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.translation;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.commands.translation.HologramTranslationCommand;
import net.thenextlvl.hologram.locale.LanguageTags;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class HologramTranslationListCommand
extends SimpleCommand {
    private HologramTranslationListCommand(HologramPlugin plugin) {
        super(plugin, "list", "holograms.command.translation.list");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramTranslationListCommand command = new HologramTranslationListCommand(plugin);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(HologramTranslationCommand.translationKeyArgument(plugin).executes((Command)command))).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSender source = ((CommandSourceStack)context.getSource()).getSender();
        this.tryGetArgument(context, "translation key", String.class).ifPresentOrElse(key -> {
            Map translations = this.plugin.translations().getTranslations((String)key);
            this.plugin.bundle().sendMessage((Audience)source, "hologram.translation.header", new TagResolver[]{Placeholder.parsed((String)"key", (String)key), Formatter.booleanChoice((String)"plural", (translations.size() != 1 ? 1 : 0) != 0), Formatter.number((String)"amount", (Number)translations.size())});
            translations.forEach((locale, translation) -> this.plugin.bundle().sendMessage((Audience)source, "hologram.translation", new TagResolver[]{Placeholder.parsed((String)"locale", (String)LanguageTags.getLanguageName(locale)), Placeholder.unparsed((String)"translation", (String)translation)}));
        }, () -> {
            List<Component> translations = this.plugin.translations().getTranslationKeys().sorted().map(key -> this.plugin.bundle().component("hologram.translation.entry", (Audience)source, new TagResolver[]{Placeholder.parsed((String)"key", (String)key)})).toList();
            this.plugin.bundle().sendMessage((Audience)source, "hologram.translation.list", Formatter.joining((String)"translations", translations), Formatter.number((String)"amount", (Number)this.plugin.translations().size()));
        });
        return 1;
    }
}

