/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.edit;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.DisplayHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.StaticHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public sealed interface LineTargetResolver {
    public static final Builder LINE = Line::new;
    public static final Builder PAGE = Page::new;

    public CommandContext<CommandSourceStack> context();

    public HologramPlugin plugin();

    public <T extends HologramLine> int resolve(Resolved<T> var1, LineType<T> var2);

    @FunctionalInterface
    public static interface Builder {
        public LineTargetResolver build(CommandContext<CommandSourceStack> var1, HologramPlugin var2);
    }

    public record LineType<T extends HologramLine>(Class<T> clazz, String errorKey) {
        public static final LineType<BlockHologramLine> BLOCK = new LineType<BlockHologramLine>(BlockHologramLine.class, "hologram.type.block");
        public static final LineType<DisplayHologramLine> DISPLAY = new LineType<DisplayHologramLine>(DisplayHologramLine.class, "hologram.type.display");
        public static final LineType<EntityHologramLine> ENTITY = new LineType<EntityHologramLine>(EntityHologramLine.class, "hologram.type.entity");
        public static final LineType<HologramLine> ANY = new LineType<HologramLine>(HologramLine.class, "hologram.type.single");
        public static final LineType<ItemHologramLine> ITEM = new LineType<ItemHologramLine>(ItemHologramLine.class, "hologram.type.item");
        public static final LineType<PagedHologramLine> PAGED = new LineType<PagedHologramLine>(PagedHologramLine.class, "hologram.type.paged");
        public static final LineType<StaticHologramLine> STATIC = new LineType<StaticHologramLine>(StaticHologramLine.class, "hologram.type.static");
        public static final LineType<TextHologramLine> TEXT = new LineType<TextHologramLine>(TextHologramLine.class, "hologram.type.text");
    }

    @FunctionalInterface
    public static interface Resolved<T extends HologramLine> {
        public int resolved(Hologram var1, T var2, int var3, @Nullable Integer var4, TagResolver ... var5);
    }

    public record Page(CommandContext<CommandSourceStack> context, HologramPlugin plugin) implements LineTargetResolver
    {
        @Override
        public <T extends HologramLine> int resolve(Resolved<T> handler, LineType<T> lineType) {
            Hologram hologram = (Hologram)this.context.getArgument("hologram", Hologram.class);
            int lineIndex = (Integer)this.context.getArgument("line", Integer.TYPE) - 1;
            int pageIndex = (Integer)this.context.getArgument("page", Integer.TYPE) - 1;
            CommandSender sender = ((CommandSourceStack)this.context.getSource()).getSender();
            HologramLine line = hologram.getLine(lineIndex).orElse(null);
            if (line == null) {
                this.plugin.bundle().sendMessage((Audience)sender, "hologram.line.invalid");
                return 0;
            }
            if (!(line instanceof PagedHologramLine)) {
                this.plugin.bundle().sendMessage((Audience)sender, "hologram.type.paged");
                return 0;
            }
            PagedHologramLine pagedLine = (PagedHologramLine)line;
            HologramLine page = pagedLine.getPage(pageIndex).orElse(null);
            if (page == null) {
                this.plugin.bundle().sendMessage((Audience)sender, "hologram.line.invalid");
                return 0;
            }
            if (!lineType.clazz.isInstance(page)) {
                this.plugin.bundle().sendMessage((Audience)sender, lineType.errorKey);
                return 0;
            }
            return handler.resolved(hologram, (HologramLine)lineType.clazz.cast(page), lineIndex, pageIndex, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1)), Formatter.number((String)"page", (Number)(pageIndex + 1))});
        }
    }

    public record Line(CommandContext<CommandSourceStack> context, HologramPlugin plugin) implements LineTargetResolver
    {
        @Override
        public <T extends HologramLine> int resolve(Resolved<T> handler, LineType<T> lineType) {
            int lineIndex;
            Hologram hologram = (Hologram)this.context.getArgument("hologram", Hologram.class);
            HologramLine line = hologram.getLine(lineIndex = (Integer)this.context.getArgument("line", Integer.TYPE) - 1).orElse(null);
            if (line == null) {
                this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)this.context.getSource()).getSender(), "hologram.line.invalid");
                return 0;
            }
            if (!lineType.clazz.isInstance(line)) {
                this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)this.context.getSource()).getSender(), lineType.errorKey);
                return 0;
            }
            return handler.resolved(hologram, (HologramLine)lineType.clazz.cast(line), lineIndex, null, new TagResolver[]{Placeholder.unparsed((String)"hologram", (String)hologram.getName()), Formatter.number((String)"line", (Number)(lineIndex + 1))});
        }
    }
}

