/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.HologramCommand;
import net.thenextlvl.hologram.commands.brigadier.SimpleCommand;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.locale.Tips;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class HologramCreateCommand
extends SimpleCommand {
    private HologramCreateCommand(HologramPlugin plugin) {
        super(plugin, "create", "holograms.command.create");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(HologramPlugin plugin) {
        HologramCreateCommand command = new HologramCreateCommand(plugin);
        RequiredArgumentBuilder position = (RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)ArgumentTypes.finePosition()).executes((Command)command);
        RequiredArgumentBuilder world = (RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).executes((Command)command);
        return (LiteralArgumentBuilder)command.create().then(((RequiredArgumentBuilder)HologramCommand.nameArgument().then(position.then((ArgumentBuilder)world))).executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String name = (String)context.getArgument("name", String.class);
        World world = this.tryGetArgument(context, "world", World.class).orElseGet(() -> ((CommandSourceStack)context.getSource()).getLocation().getWorld());
        Location location = this.resolveArgument(context, "position", FinePositionResolver.class).map(finePosition -> finePosition.toLocation(world)).orElseGet(() -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).getLocation());
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        TagResolver.Single placeholder = Placeholder.parsed((String)"hologram", (String)name);
        if (this.plugin.hologramProvider().hasHologram(name)) {
            this.plugin.bundle().sendMessage((Audience)sender, "hologram.exists", new TagResolver[]{placeholder});
            return 0;
        }
        this.plugin.hologramProvider().spawnHologram(name, location, hologram -> {
            PagedHologramLine line = hologram.addPagedLine();
            line.setInterval(Duration.ofSeconds(10L));
            for (int i = 1; i <= Tips.TIPS_ENGLISH.size(); ++i) {
                String text = "<lang:hologram.tip." + i + "><br><lang:hologram.tip.page>";
                line.addTextPage().setUnparsedText(text);
            }
        });
        this.plugin.bundle().sendMessage((Audience)sender, "hologram.created", new TagResolver[]{placeholder});
        return 1;
    }
}

