/*
 * Decompiled with CFR 0.152.
 */
package dev.faststats.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;

final class ErrorHelper {
    private static final int MESSAGE_LENGTH = Math.min(1000, Integer.getInteger("faststats.message-length", 500));
    private static final int STACK_TRACE_LENGTH = Math.min(500, Integer.getInteger("faststats.stack-trace-length", 300));
    private static final int STACK_TRACE_LIMIT = Math.min(50, Integer.getInteger("faststats.stack-trace-limit", 15));
    private static final String IPV4_PATTERN = "\\b(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\b";
    private static final String IPV6_PATTERN = "(?i)\\b([0-9a-f]{1,4}:){7}[0-9a-f]{1,4}\\b|(?i)\\b([0-9a-f]{1,4}:){1,7}:\\b|(?i)\\b([0-9a-f]{1,4}:){1,6}:[0-9a-f]{1,4}\\b|(?i)\\b([0-9a-f]{1,4}:){1,5}(:[0-9a-f]{1,4}){1,2}\\b|(?i)\\b([0-9a-f]{1,4}:){1,4}(:[0-9a-f]{1,4}){1,3}\\b|(?i)\\b([0-9a-f]{1,4}:){1,3}(:[0-9a-f]{1,4}){1,4}\\b|(?i)\\b([0-9a-f]{1,4}:){1,2}(:[0-9a-f]{1,4}){1,5}\\b|(?i)\\b[0-9a-f]{1,4}:(:[0-9a-f]{1,4}){1,6}\\b|(?i)\\b:(:[0-9a-f]{1,4}){1,7}\\b|(?i)\\b::([0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4}\\b|(?i)\\b::\\b";
    private static final String USER_HOME_PATH_PATTERN = "(/home/)[^/\\s]+|(/Users/)[^/\\s]+|((?i)[A-Z]:\\\\Users\\\\)[^\\\\\\s]+";

    ErrorHelper() {
    }

    public static JsonObject compile(Throwable error, @Nullable List<String> suppress) {
        int traces;
        JsonArray stacktrace;
        JsonObject report = new JsonObject();
        String message = ErrorHelper.getAnonymizedMessage(error);
        report.addProperty("error", error.getClass().getName());
        if (message != null) {
            report.addProperty("message", message);
        }
        StackTraceElement[] elements = error.getStackTrace();
        List<String> stack = ErrorHelper.collapseStackTrace(elements);
        ArrayList<String> list = new ArrayList<String>(stack);
        if (suppress != null) {
            list.removeAll(suppress);
        }
        if (!(stacktrace = ErrorHelper.populateTraces(traces = Math.min(list.size(), STACK_TRACE_LIMIT), list, elements)).isEmpty()) {
            report.add("stack", (JsonElement)stacktrace);
        }
        if (error.getCause() != null) {
            ArrayList<String> toSuppress = new ArrayList<String>(stack);
            if (suppress != null) {
                toSuppress.addAll(suppress);
            }
            report.add("cause", (JsonElement)ErrorHelper.compile(error.getCause(), toSuppress));
        }
        return report;
    }

    private static JsonArray populateTraces(int traces, ArrayList<String> list, StackTraceElement[] elements) {
        int i;
        JsonArray stacktrace = new JsonArray(traces);
        for (i = 0; i < traces; ++i) {
            String string = list.get(i);
            if (string.length() <= STACK_TRACE_LENGTH) {
                stacktrace.add(string);
                continue;
            }
            stacktrace.add(string.substring(0, STACK_TRACE_LENGTH) + "...");
        }
        if (traces > 0 && traces < list.size()) {
            stacktrace.add("and " + (list.size() - traces) + " more...");
        } else {
            i = elements.length - list.size();
            if (i > 0) {
                stacktrace.add("Omitted " + i + " duplicate stack frame" + (i == 1 ? "" : "s"));
            }
        }
        return stacktrace;
    }

    private static List<String> collapseStackTrace(StackTraceElement[] trace) {
        List<String> lines = Arrays.stream(trace).map(StackTraceElement::toString).toList();
        return ErrorHelper.collapseRepeatingPattern(lines);
    }

    private static List<String> collapseRepeatingPattern(List<String> lines) {
        List<String> deduplicated = ErrorHelper.collapseConsecutiveDuplicates(lines);
        int n = deduplicated.size();
        for (int cycleLen = 1; cycleLen <= n / 2; ++cycleLen) {
            boolean isPattern = true;
            int repetitions = 0;
            for (int i = 0; i < n; ++i) {
                if (!deduplicated.get(i).equals(deduplicated.get(i % cycleLen))) {
                    isPattern = false;
                    break;
                }
                if (i <= 0 || i % cycleLen != 0) continue;
                ++repetitions;
            }
            if (!isPattern || repetitions < 2) continue;
            return deduplicated.subList(0, cycleLen);
        }
        return deduplicated;
    }

    private static List<String> collapseConsecutiveDuplicates(List<String> lines) {
        if (lines.isEmpty()) {
            return lines;
        }
        ArrayList<String> result = new ArrayList<String>();
        String previous = null;
        for (String line : lines) {
            if (line.equals(previous)) continue;
            result.add(line);
            previous = line;
        }
        return result;
    }

    public static boolean isSameLoader(ClassLoader loader, Throwable error) {
        StackTraceElement[] stackTrace = error.getStackTrace();
        if (stackTrace == null || stackTrace.length == 0) {
            return false;
        }
        int firstNonLibraryIndex = ErrorHelper.findFirstNonLibraryFrameIndex(stackTrace);
        if (firstNonLibraryIndex == -1) {
            return false;
        }
        int framesToCheck = Math.min(5, stackTrace.length - firstNonLibraryIndex);
        for (int i = 0; i < framesToCheck; ++i) {
            StackTraceElement frame = stackTrace[firstNonLibraryIndex + i];
            if (ErrorHelper.isLibraryClass(frame.getClassName()) || ErrorHelper.isFromLoader(frame, loader)) continue;
            return false;
        }
        return true;
    }

    private static int findFirstNonLibraryFrameIndex(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length; ++i) {
            if (ErrorHelper.isLibraryClass(stackTrace[i].getClassName())) continue;
            return i;
        }
        return -1;
    }

    private static boolean isLibraryClass(String className) {
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("com.sun.") || className.startsWith("jdk.");
    }

    private static boolean isFromLoader(StackTraceElement frame, ClassLoader loader) {
        try {
            Class<?> clazz = Class.forName(frame.getClassName(), false, loader);
            return ErrorHelper.isSameClassLoader(clazz.getClassLoader(), loader);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isSameClassLoader(ClassLoader classLoader, ClassLoader loader) {
        ClassLoader current;
        if (classLoader == loader) {
            return true;
        }
        for (current = classLoader; current != null && current != loader; current = current.getParent()) {
        }
        return loader == current;
    }

    private static String anonymize(String message) {
        message = message.replaceAll(IPV4_PATTERN, "[IP hidden]");
        message = message.replaceAll(IPV6_PATTERN, "[IP hidden]");
        message = message.replaceAll(USER_HOME_PATH_PATTERN, "$1$2$3[username hidden]");
        String username = System.getProperty("user.name");
        if (username != null) {
            message = message.replace(username, "[username hidden]");
        }
        return message;
    }

    private static @Nullable String getAnonymizedMessage(Throwable error) {
        String message = error.getMessage();
        if (message == null) {
            return null;
        }
        String truncated = message.length() > MESSAGE_LENGTH ? message.substring(0, MESSAGE_LENGTH) + "..." : message;
        return ErrorHelper.anonymize(truncated);
    }
}

