/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.line.TextHologramLine;
import net.thenextlvl.hologram.locale.ImageTagResolver;
import net.thenextlvl.hologram.locale.MiniPlaceholdersFormatter;
import net.thenextlvl.hologram.locale.PlaceholderAPIFormatter;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperDisplayHologramLine;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PaperTextHologramLine
extends PaperDisplayHologramLine<TextDisplay>
implements TextHologramLine {
    private volatile @Nullable Color backgroundColor;
    private volatile @Nullable String unparsedText = null;
    private volatile TextDisplay.TextAlignment alignment = TextDisplay.TextAlignment.CENTER;
    private volatile boolean defaultBackground = false;
    private volatile boolean seeThrough = false;
    private volatile boolean shadowed = false;
    private volatile float opacity = 0.0f;
    private volatile int lineWidth = Integer.MAX_VALUE;

    public PaperTextHologramLine(PaperHologram hologram) {
        super(hologram, EntityType.TEXT_DISPLAY);
    }

    @Override
    public LineType getType() {
        return LineType.TEXT;
    }

    @Override
    public Optional<Component> getText(Player player) {
        return this.getUnparsedText().map(string -> this.getHologram().getPlugin().translations().translate(player, (String)string, 0)).map(string -> {
            PlaceholderAPIFormatter papiFormatter = this.getHologram().getPlugin().papiFormatter;
            return papiFormatter != null ? papiFormatter.format(player, (String)string) : string;
        }).map(string -> {
            MiniPlaceholdersFormatter formatter = this.getHologram().getPlugin().miniFormatter;
            TagResolver.Builder builder = TagResolver.builder();
            builder.resolver(StandardTags.defaults());
            builder.resolver((TagResolver)ImageTagResolver.INSTANCE);
            builder.tag("hologram", Tag.inserting((Component)Component.text((String)this.getHologram().getName())));
            builder.tag("line", Tag.inserting((Component)Component.text((int)this.getHologram().getLineIndex(this))));
            if (formatter != null) {
                builder.resolver(formatter.tagResolver());
            }
            return MiniMessage.miniMessage().deserialize(string, (Pointered)player, builder.build());
        });
    }

    @Override
    public Optional<String> getUnparsedText() {
        return Optional.ofNullable(this.unparsedText);
    }

    @Override
    public TextHologramLine setText(@Nullable Component text) {
        return this.setUnparsedText(text != null ? (String)MiniMessage.miniMessage().serialize(text) : null);
    }

    @Override
    public TextHologramLine setUnparsedText(@Nullable String text) {
        if (Objects.equals(this.unparsedText, text)) {
            return this;
        }
        this.unparsedText = text;
        this.getHologram().updateHologram();
        return this;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public TextHologramLine setLineWidth(int width) {
        if (Objects.equals(this.lineWidth, width)) {
            return this;
        }
        this.lineWidth = width;
        this.forEachEntity(entity -> entity.setLineWidth(width));
        return this;
    }

    @Override
    public Optional<Color> getBackgroundColor() {
        return Optional.ofNullable(this.backgroundColor);
    }

    @Override
    public TextHologramLine setBackgroundColor(@Nullable Color color) {
        if (Objects.equals(this.backgroundColor, color)) {
            return this;
        }
        this.backgroundColor = color;
        this.forEachEntity(entity -> entity.setBackgroundColor(color));
        return this;
    }

    @Override
    public float getTextOpacity() {
        return this.opacity;
    }

    @Override
    public TextHologramLine setTextOpacity(@Range(from=0L, to=100L) float opacity) {
        if (Objects.equals(Float.valueOf(this.opacity), Float.valueOf(opacity))) {
            return this;
        }
        this.opacity = opacity;
        this.forEachEntity(this::updateOpacity);
        return this;
    }

    @Override
    public boolean isShadowed() {
        return this.shadowed;
    }

    @Override
    public TextHologramLine setShadowed(boolean shadow) {
        if (Objects.equals(this.shadowed, shadow)) {
            return this;
        }
        this.shadowed = shadow;
        this.forEachEntity(entity -> entity.setShadowed(shadow));
        return this;
    }

    @Override
    public boolean isSeeThrough() {
        return this.seeThrough;
    }

    @Override
    public TextHologramLine setSeeThrough(boolean seeThrough) {
        if (Objects.equals(this.seeThrough, seeThrough)) {
            return this;
        }
        this.seeThrough = seeThrough;
        this.forEachEntity(entity -> entity.setSeeThrough(seeThrough));
        return this;
    }

    @Override
    public boolean isDefaultBackground() {
        return this.defaultBackground;
    }

    @Override
    public TextHologramLine setDefaultBackground(boolean defaultBackground) {
        if (Objects.equals(this.defaultBackground, defaultBackground)) {
            return this;
        }
        this.defaultBackground = defaultBackground;
        this.forEachEntity(entity -> entity.setDefaultBackground(defaultBackground));
        return this;
    }

    @Override
    public TextDisplay.TextAlignment getAlignment() {
        return this.alignment;
    }

    @Override
    public TextHologramLine setAlignment(TextDisplay.TextAlignment alignment) {
        if (Objects.equals(this.alignment, alignment)) {
            return this;
        }
        this.alignment = alignment;
        this.forEachEntity(entity -> entity.setAlignment(alignment));
        return this;
    }

    @Override
    public double getHeight(Player player) {
        return 0.25 * (double)this.transformation.getScale().y() * (double)this.getText(player).map(arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).serialize(arg_0)).map(s -> s.chars().filter(c -> c == 10).count() + 1L).orElse(1L).longValue();
    }

    @Override
    protected void preSpawn(TextDisplay entity, Player player) {
        this.updateText(player, entity);
        entity.setAlignment(this.alignment);
        entity.setSeeThrough(this.seeThrough);
        entity.setShadowed(this.shadowed);
        entity.setDefaultBackground(this.defaultBackground);
        entity.setBackgroundColor(this.backgroundColor);
        entity.setLineWidth(this.lineWidth);
        this.updateOpacity(entity);
        super.preSpawn(entity, player);
    }

    public void updateText(Player player, TextDisplay entity) {
        this.getText(player).ifPresentOrElse(component -> this.getHologram().getPlugin().supply((Entity)entity, () -> {
            entity.text((Component)Component.empty());
            entity.text(component);
        }), () -> this.getHologram().getPlugin().supply((Entity)entity, () -> entity.text(null)));
    }

    public void updateText() {
        this.entities.forEach(this::updateText);
    }

    private void updateOpacity(TextDisplay entity) {
        entity.setTextOpacity((byte)Math.round(25.0f + (100.0f - this.opacity) * 2.3f));
    }
}

