/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.hologram.action.ClickAction;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PaperHologramLine
implements HologramLine {
    protected volatile @Nullable ClickAction<?> clickAction = null;
    private final PaperHologram hologram;

    public PaperHologramLine(PaperHologram hologram) {
        this.hologram = hologram;
    }

    @Override
    public Optional<ClickAction<?>> getClickAction() {
        return Optional.ofNullable(this.clickAction);
    }

    @Override
    public HologramLine setClickAction(@Nullable ClickAction<?> clickAction) {
        return this.set(this.clickAction, clickAction, () -> {
            this.clickAction = clickAction;
        }, false);
    }

    @Override
    public PaperHologram getHologram() {
        return this.hologram;
    }

    @Override
    public World getWorld() {
        return this.hologram.getWorld();
    }

    protected <T extends HologramLine, V> T set(@Nullable V currentValue, @Nullable V newValue, Runnable setter, boolean update) {
        if (Objects.equals(currentValue, newValue)) {
            return (T)this;
        }
        setter.run();
        if (update) {
            this.hologram.updateHologram();
        }
        return (T)this;
    }

    public abstract double getHeight(Player var1);

    public double getOffsetBefore(Player player) {
        return 0.0;
    }

    public double getOffsetAfter(Player player) {
        return 0.0;
    }

    public abstract CompletableFuture<@Nullable Entity> spawn(Player var1, double var2);

    public abstract CompletableFuture<Void> despawn();

    public abstract CompletableFuture<@Nullable Void> despawn(Player var1);

    public abstract void invalidate(Entity var1);

    public abstract CompletableFuture<Void> teleportRelative(Location var1, Location var2);
}

