/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import com.destroystokyo.paper.entity.Pathfinder;
import com.google.common.base.Preconditions;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.LineType;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperStaticHologramLine;
import org.bukkit.Location;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.inventory.EquipmentSlot;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PaperEntityHologramLine
extends PaperStaticHologramLine<Entity>
implements EntityHologramLine {
    private volatile Vector3f offset = new Vector3f();
    private volatile double scale = 1.0;

    public PaperEntityHologramLine(PaperHologram hologram, EntityType entityType) throws IllegalArgumentException {
        super(hologram, entityType);
    }

    @Override
    protected void updateGlowColor(@Nullable TextColor color) {
        this.entities.forEach(this::updateTeamOptions);
    }

    @Override
    public double getHeight(Player player) {
        return (double)this.getEntity(player, CraftEntity.class).map(CraftEntity::getHandleRaw).map(net.minecraft.world.entity.Entity::getBbHeight).orElse(Float.valueOf(0.0f)).floatValue() * this.scale;
    }

    @Override
    public double getOffsetAfter(Player player) {
        return 0.1;
    }

    @Override
    public LineType getType() {
        return LineType.ENTITY;
    }

    @Override
    public EntityHologramLine setEntityType(EntityType entityType) throws IllegalArgumentException {
        return (EntityHologramLine)this.set(this.entityType, entityType, () -> {
            Preconditions.checkArgument((entityType.getEntityClass() != null ? 1 : 0) != 0, (String)"Entity type %s is not spawnable", (Object)entityType);
            this.entityClass = entityType.getEntityClass();
            this.entityType = entityType;
        }, true);
    }

    @Override
    public EntityHologramLine setEntityType(Class<Entity> entityType) throws IllegalArgumentException {
        return this.setEntityType(HologramPlugin.getEntityType(entityType));
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public EntityHologramLine setScale(double scale) {
        return (EntityHologramLine)this.set(this.scale, scale, () -> {
            if (this.scale == scale) {
                return;
            }
            this.scale = scale;
        }, true);
    }

    @Override
    public Vector3f getOffset() {
        return new Vector3f((Vector3fc)this.offset);
    }

    @Override
    public EntityHologramLine setOffset(Vector3f newOffset) {
        Vector3f copy;
        Vector3f oldOffset = this.offset;
        if (oldOffset.equals((Object)newOffset)) {
            return this;
        }
        this.offset = copy = new Vector3f((Vector3fc)newOffset);
        this.forEachEntity(entity -> {
            Location location = entity.getLocation();
            location.subtract((double)oldOffset.x(), (double)oldOffset.y(), (double)oldOffset.z());
            location.add((double)copy.x(), (double)copy.y(), (double)copy.z());
            entity.teleportAsync(location);
        });
        return this;
    }

    @Override
    protected Location mutateSpawnLocation(Location location) {
        return location.add((double)this.offset.x(), (double)this.offset.y(), (double)this.offset.z());
    }

    @Override
    protected void preSpawn(Entity entity, Player player) {
        Attributable attributable;
        AttributeInstance attribute;
        TNTPrimed explosive;
        entity.setSilent(true);
        entity.setInvulnerable(true);
        entity.setGravity(false);
        entity.setNoPhysics(true);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            this.getHologram().getPlugin().getServer().getMobGoals().removeAllGoals(mob);
            mob.setDespawnInPeacefulOverride(TriState.FALSE);
            mob.setAware(false);
        }
        if (entity instanceof TNTPrimed) {
            explosive = (TNTPrimed)entity;
            explosive.setFuseTicks(Integer.MAX_VALUE);
        }
        if (entity instanceof Explosive) {
            explosive = (Explosive)entity;
            explosive.setIsIncendiary(false);
            explosive.setYield(0.0f);
        }
        if (entity instanceof Pathfinder) {
            Pathfinder pathfinder = (Pathfinder)entity;
            pathfinder.setCanFloat(false);
            pathfinder.setCanOpenDoors(false);
            pathfinder.setCanPassDoors(false);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.setAI(false);
            livingEntity.setCollidable(false);
            livingEntity.setCanPickupItems(false);
            livingEntity.setRemoveWhenFarAway(true);
        }
        if (entity instanceof Attributable && (attribute = (attributable = (Attributable)entity).getAttribute(Attribute.SCALE)) != null) {
            attribute.setBaseValue(this.scale);
        }
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            armorStand.setDisabledSlots(EquipmentSlot.values());
        }
        super.preSpawn(entity, player);
    }
}

