/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.event;

import net.thenextlvl.hologram.Hologram;
import net.thenextlvl.hologram.event.HologramEvent;
import org.bukkit.Location;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class HologramTeleportEvent
extends HologramEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Location from;
    private Location to;
    private boolean cancelled;

    @ApiStatus.Internal
    public HologramTeleportEvent(Hologram hologram, Location from, Location to) {
        super(hologram);
        this.from = from;
        this.to = to;
    }

    @Contract(value=" -> new", pure=true)
    public Location getFrom() {
        return this.from.clone();
    }

    @Contract(value=" -> new", pure=true)
    public Location getTo() {
        return this.to.clone();
    }

    @Contract(mutates="this")
    public void setTo(Location to) {
        this.to = to.clone();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    @Contract(pure=true)
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

