/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.commands.edit;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.commands.arguments.ColorArgumentType;
import net.thenextlvl.hologram.commands.arguments.EnumArgumentType;
import net.thenextlvl.hologram.commands.edit.LineEditTarget;
import net.thenextlvl.hologram.commands.edit.LineTargetResolver;
import net.thenextlvl.hologram.line.BlockHologramLine;
import net.thenextlvl.hologram.line.DisplayHologramLine;
import net.thenextlvl.hologram.line.EntityHologramLine;
import net.thenextlvl.hologram.line.HologramLine;
import net.thenextlvl.hologram.line.ItemHologramLine;
import net.thenextlvl.hologram.line.PagedHologramLine;
import net.thenextlvl.hologram.line.StaticHologramLine;
import net.thenextlvl.hologram.line.TextHologramLine;
import org.bukkit.Color;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class EditCommands {
    private final HologramPlugin plugin;
    private final LineTargetResolver resolver;

    public EditCommands(HologramPlugin plugin, LineTargetResolver resolver) {
        this.plugin = plugin;
        this.resolver = resolver;
    }

    public LiteralArgumentBuilder<CommandSourceStack> alignment() {
        return this.create("alignment").textType().enumArg(TextDisplay.TextAlignment.class, TextHologramLine::setAlignment).successMessage("hologram.text-alignment").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> append() {
        return this.create("append").textType().textArg((line, text) -> line.getUnparsedText().map(s -> s.concat((String)text)).ifPresent(line::setUnparsedText)).successMessage("hologram.text.set").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> prepend() {
        return this.create("prepend").textType().textArg((line, text) -> line.getUnparsedText().map(text::concat).ifPresent(line::setUnparsedText)).successMessage("hologram.text.set").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> replace() {
        RequiredArgumentBuilder matchArg = Commands.argument((String)"match", (ArgumentType)StringArgumentType.string());
        RequiredArgumentBuilder replacementArg = Commands.argument((String)"replacement", (ArgumentType)StringArgumentType.greedyString());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"replace").requires(EditCommands.requiresPermission("replace"))).then(matchArg.then(replacementArg.executes(context -> this.editTyped((CommandContext<CommandSourceStack>)context, TextHologramLine.class, "hologram.type.text", line -> {
            String match = (String)context.getArgument("match", String.class);
            String replacement = (String)context.getArgument("replacement", String.class);
            line.getUnparsedText().map(s -> s.replace(match, replacement)).ifPresent(line::setUnparsedText);
        }, "hologram.text.set"))));
    }

    public LiteralArgumentBuilder<CommandSourceStack> backgroundColor() {
        return this.create("background-color").textType().reset(line -> line.setBackgroundColor(null), "hologram.background-color.reset").arg("color", new ColorArgumentType(), Color.class, TextHologramLine::setBackgroundColor).successMessage("hologram.background-color").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> billboard() {
        return this.create("billboard").displayType().enumArg(Display.Billboard.class, DisplayHologramLine::setBillboard).successMessage("hologram.billboard").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> brightness() {
        RequiredArgumentBuilder brightnessArg = Commands.argument((String)"brightness", (ArgumentType)IntegerArgumentType.integer((int)0, (int)15));
        RequiredArgumentBuilder blockArg = Commands.argument((String)"block", (ArgumentType)IntegerArgumentType.integer((int)0, (int)15));
        RequiredArgumentBuilder skyArg = Commands.argument((String)"sky", (ArgumentType)IntegerArgumentType.integer((int)0, (int)15));
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"brightness").requires(EditCommands.requiresPermission("brightness"))).then(Commands.literal((String)"reset").executes(context -> this.editTyped((CommandContext<CommandSourceStack>)context, DisplayHologramLine.class, "hologram.type.display", line -> line.setBrightness(null), "hologram.brightness.reset")))).then(brightnessArg.executes(context -> this.editTyped((CommandContext<CommandSourceStack>)context, DisplayHologramLine.class, "hologram.type.display", line -> {
            Integer brightness = (Integer)context.getArgument("brightness", Integer.TYPE);
            line.setBrightness(new Display.Brightness(brightness.intValue(), brightness.intValue()));
        }, "hologram.brightness")))).then(blockArg.then(skyArg.executes(context -> this.editTyped((CommandContext<CommandSourceStack>)context, DisplayHologramLine.class, "hologram.type.display", line -> {
            Integer block = (Integer)context.getArgument("block", Integer.TYPE);
            Integer sky = (Integer)context.getArgument("sky", Integer.TYPE);
            line.setBrightness(new Display.Brightness(block.intValue(), sky.intValue()));
        }, "hologram.brightness"))));
    }

    public LiteralArgumentBuilder<CommandSourceStack> defaultBackground() {
        return this.create("default-background").textType().boolArg(TextHologramLine::setDefaultBackground).successMessage("hologram.default-background").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> glowColor() {
        return this.create("glow-color").typed(StaticHologramLine.class, "hologram.type.single").reset(line -> line.setGlowColor(null), "hologram.line.glow-color.reset").arg("color", ArgumentTypes.namedColor(), NamedTextColor.class, StaticHologramLine::setGlowColor).arg("hex", ArgumentTypes.hexColor(), TextColor.class, StaticHologramLine::setGlowColor).successMessage("hologram.line.glow-color").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> glowing() {
        RequiredArgumentBuilder glowingArg = Commands.argument((String)"glowing", (ArgumentType)BoolArgumentType.bool());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"glowing").requires(EditCommands.requiresPermission("glowing"))).then(glowingArg.executes(context -> {
            Boolean glowing = (Boolean)context.getArgument("glowing", Boolean.TYPE);
            return this.editTyped((CommandContext<CommandSourceStack>)context, StaticHologramLine.class, "hologram.type.single", line -> line.setGlowing(glowing), glowing != false ? "hologram.line.glow.enabled" : "hologram.line.glow.disabled");
        }));
    }

    public LiteralArgumentBuilder<CommandSourceStack> interpolationDelay() {
        return this.create("interpolation-delay").displayType().intArg("delay", 0, DisplayHologramLine::setInterpolationDelay).successMessage("hologram.interpolation-delay").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> interpolationDuration() {
        return this.create("interpolation-duration").displayType().intArg("duration", 0, DisplayHologramLine::setInterpolationDuration).successMessage("hologram.interpolation-duration").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> offset() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"offset").requires(EditCommands.requiresPermission("offset"))).then(Commands.literal((String)"reset").executes(context -> this.editForOffset((CommandContext<CommandSourceStack>)context, new Vector3f())))).then(EditCommands.vector3fArguments(-16.0f, 16.0f, this::editForOffset));
    }

    private int editForOffset(CommandContext<CommandSourceStack> context, Vector3f offset) {
        return this.editDisplayOrEntity(context, "hologram.offset", displayLine -> displayLine.getTransformation().getTranslation().set((Vector3fc)offset), entityLine -> entityLine.setOffset(offset));
    }

    public LiteralArgumentBuilder<CommandSourceStack> opacity() {
        return this.create("opacity").textType().arg("opacity", FloatArgumentType.floatArg((float)0.0f, (float)100.0f), Float.TYPE, TextHologramLine::setTextOpacity).successMessage("hologram.opacity").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> scale() {
        RequiredArgumentBuilder scaleArg = Commands.argument((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.1f));
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"scale").requires(EditCommands.requiresPermission("scale"))).then(scaleArg.executes(this::editForScale))).then(EditCommands.vector3fArguments(0.1f, 100.0f, (context, vector) -> this.editForScale((CommandContext<CommandSourceStack>)context)));
    }

    private int editForScale(CommandContext<CommandSourceStack> context) {
        Vector3f scale = EditCommands.tryGetArgument(context, "scale", Float.TYPE).map(Vector3f::new).orElseGet(() -> EditCommands.getVector3f(context));
        return this.editDisplayOrEntity(context, "hologram.scale", displayLine -> {
            Transformation transformation = displayLine.getTransformation();
            transformation.getScale().set((Vector3fc)scale);
            displayLine.setTransformation(transformation);
        }, entityLine -> entityLine.setScale(scale.y()));
    }

    public LiteralArgumentBuilder<CommandSourceStack> seeThrough() {
        return this.create("see-through").textType().boolArg(TextHologramLine::setSeeThrough).successMessage("hologram.see-through").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> shadowed() {
        return this.create("shadowed").textType().boolArg(TextHologramLine::setShadowed).successMessage("hologram.shadowed").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> teleportDuration() {
        return this.create("teleport-duration").displayType().intArg("duration", 0, DisplayHologramLine::setTeleportDuration).successMessage("hologram.teleport-duration").build();
    }

    public LiteralArgumentBuilder<CommandSourceStack> transformation() {
        return this.create("transformation").typed(ItemHologramLine.class, "hologram.type.item").enumArg(ItemDisplay.ItemDisplayTransform.class, ItemHologramLine::setItemDisplayTransform).successMessage("hologram.transformation").build();
    }

    private EditBuilder<HologramLine> create(String name) {
        return new EditBuilder<HologramLine>(name, HologramLine.class, "hologram.type.line");
    }

    private static Predicate<CommandSourceStack> requiresPermission(String command) {
        return source -> source.getSender().hasPermission("holograms.command.edit." + command);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> vector3fArguments(float min, float max, BiFunction<CommandContext<CommandSourceStack>, Vector3f, Integer> handler) {
        RequiredArgumentBuilder x = Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)min, (float)max));
        RequiredArgumentBuilder y = Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)min, (float)max));
        RequiredArgumentBuilder z = Commands.argument((String)"z", (ArgumentType)FloatArgumentType.floatArg((float)min, (float)max));
        return x.then(y.then(z.executes(context -> (Integer)handler.apply(context, EditCommands.getVector3f((CommandContext<CommandSourceStack>)context)))));
    }

    private static Vector3f getVector3f(CommandContext<CommandSourceStack> context) {
        Float x = (Float)context.getArgument("x", Float.TYPE);
        Float y = (Float)context.getArgument("y", Float.TYPE);
        Float z = (Float)context.getArgument("z", Float.TYPE);
        return new Vector3f(x.floatValue(), y.floatValue(), z.floatValue());
    }

    private int editDisplayOrEntity(CommandContext<CommandSourceStack> context, String successKey, Consumer<DisplayHologramLine> displayAction, Consumer<EntityHologramLine> entityAction) {
        LineEditTarget target = this.resolver.resolve(context, this.plugin);
        if (target == null) {
            return 0;
        }
        HologramLine line = target.line();
        if (line instanceof DisplayHologramLine) {
            DisplayHologramLine displayLine = (DisplayHologramLine)line;
            displayAction.accept(displayLine);
        } else if (line instanceof EntityHologramLine) {
            EntityHologramLine entityLine = (EntityHologramLine)line;
            entityAction.accept(entityLine);
        } else {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "hologram.type.display", EditCommands.buildPlaceholders(target));
            return 0;
        }
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), successKey, EditCommands.buildPlaceholders(target));
        return 1;
    }

    public LiteralArgumentBuilder<CommandSourceStack> set() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").requires(source -> source.getSender().hasPermission("holograms.command.edit.set"))).then(this.setType("block", ArgumentTypes.blockState(), BlockHologramLine.class, (context, line) -> {
            BlockData block = ((BlockState)context.getArgument("block", BlockState.class)).getBlockData();
            line.setBlock(block);
            return true;
        }))).then(this.setType("entity", ArgumentTypes.resource((RegistryKey)RegistryKey.ENTITY_TYPE), EntityHologramLine.class, (context, line) -> {
            EntityType entity = (EntityType)context.getArgument("entity", EntityType.class);
            line.setEntityType(entity);
            return true;
        }))).then(this.setType("item", ArgumentTypes.itemStack(), ItemHologramLine.class, (context, line) -> {
            ItemStack item = (ItemStack)context.getArgument("item", ItemStack.class);
            line.setItemStack(item);
            return true;
        }))).then(this.setType("text", (ArgumentType<?>)StringArgumentType.greedyString(), (Class)TextHologramLine.class, (context, line) -> {
            String text = (String)context.getArgument("text", String.class);
            line.setUnparsedText(text);
            return true;
        }));
    }

    private <T extends HologramLine> LiteralArgumentBuilder<CommandSourceStack> setType(String name, ArgumentType<?> argumentType, Class<T> lineType, SetHandler<T> handler) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(Commands.argument((String)name, argumentType).executes(context -> {
            LineEditTarget result = this.resolver.resolve((CommandContext<CommandSourceStack>)context, this.plugin);
            if (result == null) {
                return 0;
            }
            HologramLine line = result.line();
            if (!lineType.isInstance(line)) {
                if (lineType.equals(BlockHologramLine.class)) {
                    line = result.hologram().setBlockLine(result.lineIndex());
                } else if (lineType.equals(EntityHologramLine.class)) {
                    line = result.hologram().setEntityLine(result.lineIndex(), EntityType.ACACIA_BOAT);
                } else if (lineType.equals(ItemHologramLine.class)) {
                    line = result.hologram().setItemLine(result.lineIndex());
                } else if (lineType.equals(TextHologramLine.class)) {
                    line = result.hologram().setTextLine(result.lineIndex());
                } else if (lineType.equals(PagedHologramLine.class)) {
                    line = result.hologram().setPagedLine(result.lineIndex());
                } else {
                    throw new IllegalArgumentException("Invalid line type: " + String.valueOf(lineType));
                }
            }
            if (handler.apply((CommandContext<CommandSourceStack>)context, (HologramLine)lineType.cast(line))) {
                this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), result.isPage() ? "hologram.page.set" : "hologram.line.set", EditCommands.buildPlaceholders(result));
                return 1;
            }
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "hologram.type.not.paged", EditCommands.buildPlaceholders(result));
            return 0;
        }));
    }

    private <T extends HologramLine> int editTyped(CommandContext<CommandSourceStack> context, Class<T> type, String wrongTypeKey, Consumer<T> change, String successKey) {
        LineEditTarget target = this.resolver.resolve(context, this.plugin);
        if (target == null) {
            return 0;
        }
        if (!type.isInstance(target.line())) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), wrongTypeKey, EditCommands.buildPlaceholders(target));
            return 0;
        }
        change.accept((HologramLine)type.cast(target.line()));
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), successKey, EditCommands.buildPlaceholders(target));
        return 1;
    }

    private static TagResolver[] buildPlaceholders(LineEditTarget target) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(Placeholder.unparsed((String)"hologram", (String)target.hologram().getName()));
        list.add(Formatter.number((String)"line", (Number)target.displayLineIndex()));
        if (target.isPage()) {
            list.add(Formatter.number((String)"page", (Number)target.displayPageIndex()));
        }
        return (TagResolver[])list.toArray(TagResolver[]::new);
    }

    private static <T> Optional<T> tryGetArgument(CommandContext<CommandSourceStack> context, String name, Class<T> type) {
        try {
            return Optional.of(context.getArgument(name, type));
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().equals("No such argument '" + name + "' exists on this command")) {
                return Optional.empty();
            }
            throw e;
        }
    }

    public static <T extends ArgumentBuilder<CommandSourceStack, T>> T addAllEditCommands(T builder, HologramPlugin plugin, LineTargetResolver resolver) {
        EditCommands command = new EditCommands(plugin, resolver);
        return (T)builder.then(command.alignment()).then(command.append()).then(command.backgroundColor()).then(command.billboard()).then(command.brightness()).then(command.defaultBackground()).then(command.glowColor()).then(command.glowing()).then(command.interpolationDelay()).then(command.interpolationDuration()).then(command.offset()).then(command.opacity()).then(command.prepend()).then(command.replace()).then(command.scale()).then(command.seeThrough()).then(command.set()).then(command.shadowed()).then(command.teleportDuration()).then(command.transformation());
    }

    private final class EditBuilder<T extends HologramLine> {
        private final String name;
        private final Class<T> lineType;
        private final String wrongTypeKey;
        private final LiteralArgumentBuilder<CommandSourceStack> builder;
        private @Nullable String successKey = null;

        private EditBuilder(String name, Class<T> lineType, String wrongTypeKey) {
            this.name = name;
            this.lineType = lineType;
            this.wrongTypeKey = wrongTypeKey;
            this.builder = (LiteralArgumentBuilder)Commands.literal((String)name).requires(EditCommands.requiresPermission(name));
        }

        private <U extends HologramLine> EditBuilder<U> typed(Class<U> type, String wrongTypeKey) {
            return new EditBuilder<U>(this.name, type, wrongTypeKey);
        }

        EditBuilder<TextHologramLine> textType() {
            return this.typed(TextHologramLine.class, "hologram.type.text");
        }

        EditBuilder<DisplayHologramLine> displayType() {
            return this.typed(DisplayHologramLine.class, "hologram.type.display");
        }

        EditBuilder<T> successMessage(String key) {
            this.successKey = key;
            return this;
        }

        <E extends Enum<E>> EditBuilder<T> enumArg(Class<E> enumClass, BiConsumer<T, E> setter) {
            return this.arg(this.name, (ArgumentType)new EnumArgumentType<E>(enumClass), (Class)enumClass, (BiConsumer)setter);
        }

        EditBuilder<T> boolArg(BiConsumer<T, Boolean> setter) {
            return this.arg(this.name, (ArgumentType)BoolArgumentType.bool(), (Class)Boolean.TYPE, (BiConsumer)setter);
        }

        EditBuilder<T> intArg(String argName, int min, BiConsumer<T, Integer> setter) {
            return this.arg(argName, (ArgumentType)IntegerArgumentType.integer((int)min), (Class)Integer.TYPE, (BiConsumer)setter);
        }

        EditBuilder<T> textArg(BiConsumer<T, String> action) {
            return this.arg("text", (ArgumentType)StringArgumentType.greedyString(), (Class)String.class, (BiConsumer)action);
        }

        <A> EditBuilder<T> arg(String argName, ArgumentType<A> argType, Class<A> valueType, BiConsumer<T, A> setter) {
            this.builder.then(Commands.argument((String)argName, argType).executes(context -> EditCommands.this.editTyped((CommandContext<CommandSourceStack>)context, this.lineType, this.wrongTypeKey, line -> setter.accept(line, context.getArgument(argName, valueType)), Objects.requireNonNull(this.successKey, "successKey cannot be null"))));
            return this;
        }

        EditBuilder<T> reset(Consumer<T> resetAction, String resetSuccessKey) {
            this.builder.then(Commands.literal((String)"reset").executes(context -> EditCommands.this.editTyped((CommandContext<CommandSourceStack>)context, this.lineType, this.wrongTypeKey, resetAction, resetSuccessKey)));
            return this;
        }

        LiteralArgumentBuilder<CommandSourceStack> build() {
            return this.builder;
        }
    }

    @FunctionalInterface
    private static interface SetHandler<T extends HologramLine> {
        public boolean apply(CommandContext<CommandSourceStack> var1, T var2);
    }
}

