/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.hologram.models.line;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.thenextlvl.hologram.HologramPlugin;
import net.thenextlvl.hologram.line.StaticHologramLine;
import net.thenextlvl.hologram.models.PaperHologram;
import net.thenextlvl.hologram.models.line.PaperHologramLine;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PaperStaticHologramLine<E extends Entity>
extends PaperHologramLine
implements StaticHologramLine {
    private final Class<E> entityClass;
    private final EntityType entityType;
    private final Map<Player, E> entities = new ConcurrentHashMap<Player, E>();
    protected volatile @Nullable TextColor glowColor = null;
    protected volatile boolean glowing = false;

    public PaperStaticHologramLine(PaperHologram hologram, Class<E> entityClass) {
        super(hologram);
        this.entityType = Arrays.stream(EntityType.values()).filter(type -> type.getEntityClass() != null).filter(type -> type.getEntityClass().isAssignableFrom(entityClass)).findAny().orElseThrow(() -> new IllegalArgumentException("Entity type not found for " + String.valueOf(entityClass)));
        this.entityClass = entityClass;
    }

    @Override
    public Optional<TextColor> getGlowColor() {
        return Optional.ofNullable(this.glowColor);
    }

    @Override
    public StaticHologramLine setGlowColor(@Nullable TextColor color) {
        if (Objects.equals(this.glowColor, color)) {
            return this;
        }
        this.glowColor = color;
        this.updateGlowColor(color);
        return this;
    }

    @Override
    public boolean isGlowing() {
        return this.glowing;
    }

    @Override
    public StaticHologramLine setGlowing(boolean glowing) {
        if (glowing == this.glowing) {
            return this;
        }
        this.glowing = glowing;
        this.forEachEntity(entity -> entity.setGlowing(glowing));
        return this;
    }

    protected abstract void updateGlowColor(@Nullable TextColor var1);

    @Override
    public Class<? extends Entity> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public Optional<Entity> getEntity(Player player) {
        return Optional.ofNullable((Entity)this.entities.get(player));
    }

    public Map<Player, E> getEntities() {
        return this.entities;
    }

    public void forEachEntity(Consumer<E> consumer) {
        this.entities.values().forEach(consumer);
    }

    @Override
    public <T> Optional<T> getEntity(Player player, Class<T> type) {
        return this.getEntity(player).filter(type::isInstance).map(type::cast);
    }

    protected final void updateTeamOptions(Player player, Entity entity) {
        if (HologramPlugin.RUNNING_FOLIA) {
            return;
        }
        Team team = this.getSettingsTeam(player, entity);
        team.color((NamedTextColor)this.getGlowColor().map(NamedTextColor::nearestTo).orElse(null));
        team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
    }

    private Team getSettingsTeam(Player player, Entity entity) {
        Team settings = player.getScoreboard().getTeam(entity.getScoreboardEntryName());
        if (settings != null) {
            return settings;
        }
        settings = player.getScoreboard().registerNewTeam(entity.getScoreboardEntryName());
        settings.addEntry(entity.getScoreboardEntryName());
        return settings;
    }

    @Override
    public void despawn() {
        this.entities.values().removeIf(entity -> {
            entity.remove();
            return true;
        });
    }

    @Override
    public void despawn(Player player) {
        Entity remove = (Entity)this.entities.remove(player);
        if (remove != null) {
            remove.remove();
        }
    }

    public @Nullable E removeEntity(Player player) {
        return (E)((Entity)this.entities.remove(player));
    }

    public boolean adoptEntity(Player player, Entity entity) {
        if (!this.entityClass.isInstance(entity)) {
            return false;
        }
        this.entities.put(player, entity);
        this.getHologram().getPlugin().supplySync(entity, () -> this.preSpawn(entity, player));
        return true;
    }

    @Override
    public Entity spawn(Player player, double offset) {
        return this.entities.compute(player, (p, existing) -> {
            if (existing != null && existing.isValid()) {
                return existing;
            }
            Location location = this.mutateSpawnLocation(this.getHologram().getLocation().add(0.0, offset, 0.0));
            Entity spawn = location.getWorld().spawn(location, this.entityClass, false, e -> this.preSpawn(e, player));
            player.showEntity((Plugin)this.getHologram().getPlugin(), spawn);
            return spawn;
        });
    }

    protected Location mutateSpawnLocation(Location location) {
        return location;
    }

    @Override
    public CompletableFuture<Void> teleportRelative(Location previous, Location location) {
        return CompletableFuture.allOf((CompletableFuture[])this.getEntities().values().stream().filter(Entity::isValid).map(entity -> entity.teleportAsync(new Location(location.getWorld(), location.getX() + entity.getX() - previous.getX(), location.getY() + entity.getY() - previous.getY(), location.getZ() + entity.getZ() - previous.getZ(), location.getYaw(), location.getPitch()))).toArray(CompletableFuture[]::new));
    }

    protected void preSpawn(E entity, Player player) {
        this.updateTeamOptions(player, (Entity)entity);
        entity.setPersistent(false);
        entity.setVisibleByDefault(false);
        entity.setGlowing(this.glowing);
        this.updateGlowColor(this.glowColor);
    }

    private @Nullable Player remove(Entity entity) {
        Iterator<Map.Entry<Player, E>> iterator = this.entities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Player, E> entry = iterator.next();
            if (!((Entity)entry.getValue()).equals((Object)entity)) continue;
            iterator.remove();
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void invalidate(Entity entity) {
        Player owner = this.remove(entity);
        if (owner == null) {
            return;
        }
        Team team = owner.getScoreboard().getTeam(entity.getScoreboardEntryName());
        if (team != null) {
            team.unregister();
        }
    }

    @Override
    public boolean isPart(Entity entity) {
        return this.entityClass.isInstance(entity) && this.entities.containsValue(this.entityClass.cast(entity));
    }
}

